# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED TCMALLOC_HEAPPROFILER_LIBRARIES)

set(CHECK_COMPILES_BODY "HeapProfilerStart(\"profiler\");")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("TCMALLOC_HEAPPROFILER_PKGCONF" "tcmalloc_heapprofiler")

# Include dir
find_path("TCMALLOC_HEAPPROFILER_INCLUDE_DIR"
  NAMES gperftools/heap-profiler.h
  PATHS ${TCMALLOC_HEAPPROFILER_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib )
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${TCMALLOC_HEAPPROFILER_PKGCONF_LIBRARY_DIRS}
)
list(APPEND TCMALLOC_HEAPPROFILER_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(TCMALLOC_HEAPPROFILER_PROCESS_INCLUDES TCMALLOC_HEAPPROFILER_INCLUDE_DIR)
set(TCMALLOC_HEAPPROFILER_PROCESS_LIBS TCMALLOC_HEAPPROFILER_LIBRARY)

# clear target variable
set(TCMALLOC_HEAPPROFILER_LIBRARIES "" CACHE INTERNAL "")
libfind_process(TCMALLOC_HEAPPROFILER)

if ("${TCMALLOC_HEAPPROFILER_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${TCMALLOC_HEAPPROFILER_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("TCMalloc_HeapProfiler not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/TCMalloc_HeapProfiler" "ok=False")
else()
  check_compiles("_found" "TCMalloc_HeapProfiler" "TCMALLOC_HEAPPROFILER" "#include <gperftools/heap-profiler.h>" "${TCMALLOC_HEAPPROFILER_INCLUDE_DIR}" "${TCMALLOC_HEAPPROFILER_LIBRARIES}" TCMALLOC_HEAPPROFILER_ok_ok)
  if(${TCMALLOC_HEAPPROFILER_ok_ok} MATCHES "1")
    message(STATUS "Found TCMalloc_HeapProfiler")
  else()
    message("TCMalloc_HeapProfiler not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/TCMalloc_HeapProfiler" "ok=False")
  endif()
endif()
else()
#message(STATUS "TCMALLOC_HEAPPROFILER already setup")

endif(NOT DEFINED TCMALLOC_HEAPPROFILER_LIBRARIES)
