# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED TCMALLOC_HEAPCHECKER_LIBRARIES)

set(CHECK_COMPILES_BODY "new HeapLeakChecker(\"profiler\");")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("TCMALLOC_HEAPCHECKER_PKGCONF" "tcmalloc_heapchecker")

# Include dir
find_path("TCMALLOC_HEAPCHECKER_INCLUDE_DIR"
  NAMES gperftools/heap-checker.h
  PATHS ${TCMALLOC_HEAPCHECKER_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib )
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${TCMALLOC_HEAPCHECKER_PKGCONF_LIBRARY_DIRS}
)
list(APPEND TCMALLOC_HEAPCHECKER_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(TCMALLOC_HEAPCHECKER_PROCESS_INCLUDES TCMALLOC_HEAPCHECKER_INCLUDE_DIR)
set(TCMALLOC_HEAPCHECKER_PROCESS_LIBS TCMALLOC_HEAPCHECKER_LIBRARY)

# clear target variable
set(TCMALLOC_HEAPCHECKER_LIBRARIES "" CACHE INTERNAL "")
libfind_process(TCMALLOC_HEAPCHECKER)

if ("${TCMALLOC_HEAPCHECKER_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${TCMALLOC_HEAPCHECKER_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("TCMalloc_HeapChecker not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/TCMalloc_HeapChecker" "ok=False")
else()
  check_compiles("_found" "TCMalloc_HeapChecker" "TCMALLOC_HEAPCHECKER" "#include <gperftools/heap-checker.h>" "${TCMALLOC_HEAPCHECKER_INCLUDE_DIR}" "${TCMALLOC_HEAPCHECKER_LIBRARIES}" TCMALLOC_HEAPCHECKER_ok_ok)
  if(${TCMALLOC_HEAPCHECKER_ok_ok} MATCHES "1")
    message(STATUS "Found TCMalloc_HeapChecker")
  else()
    message("TCMalloc_HeapChecker not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/TCMalloc_HeapChecker" "ok=False")
  endif()
endif()
else()
#message(STATUS "TCMALLOC_HEAPCHECKER already setup")

endif(NOT DEFINED TCMALLOC_HEAPCHECKER_LIBRARIES)
