# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED GPERFTOOLS_LIBRARIES)

set(CHECK_COMPILES_BODY "ProfilerStop();")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("GPERFTOOLS_PKGCONF" "gperftools")

# Include dir
find_path("GPERFTOOLS_INCLUDE_DIR"
  NAMES gperftools/profiler.h
  PATHS ${GPERFTOOLS_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib profiler)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${GPERFTOOLS_PKGCONF_LIBRARY_DIRS}
)
list(APPEND GPERFTOOLS_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(GPERFTOOLS_PROCESS_INCLUDES GPERFTOOLS_INCLUDE_DIR)
set(GPERFTOOLS_PROCESS_LIBS GPERFTOOLS_LIBRARY)

# clear target variable
set(GPERFTOOLS_LIBRARIES "" CACHE INTERNAL "")
libfind_process(GPERFTOOLS)

if ("${GPERFTOOLS_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${GPERFTOOLS_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("GPerfTools not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/GPerfTools" "ok=False")
else()
  check_compiles("_found" "GPerfTools" "GPERFTOOLS" "#include <gperftools/profiler.h>" "${GPERFTOOLS_INCLUDE_DIR}" "${GPERFTOOLS_LIBRARIES}" GPERFTOOLS_ok_ok)
  if(${GPERFTOOLS_ok_ok} MATCHES "1")
    message(STATUS "Found GPerfTools")
  else()
    message("GPerfTools not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/GPerfTools" "ok=False")
  endif()
endif()
else()
#message(STATUS "GPERFTOOLS already setup")

endif(NOT DEFINED GPERFTOOLS_LIBRARIES)
