var NAVTREE =
[
  [ "IMP", "index.html", [
    [ "IMP Documentation", "index.html", null ],
    [ "Application Index", "applications_index.html", "applications_index" ],
    [ "Argument Index", "argument_index.html", null ],
    [ "Class Examples", "class_example_index.html", null ],
    [ "Modeling of GroEL with cnmultifit", "cnmultifit_groel.html", [
      [ "Introduction", "cnmultifit_groel.html#intro", null ],
      [ "Setup", "cnmultifit_groel.html#setup", null ],
      [ "Model generation", "cnmultifit_groel.html#modgen", null ],
      [ "Analysis", "cnmultifit_groel.html#analysis", null ]
    ] ],
    [ "Modeling of 3sfd with EMageFit", "emagefit_3sfd.html", [
      [ "Introduction", "emagefit_3sfd.html#intro", null ],
      [ "Setup", "emagefit_3sfd.html#setup", null ],
      [ "Pairwise docking", "emagefit_3sfd.html#dock", null ],
      [ "SA-MC optimization", "emagefit_3sfd.html#optimize", [
        [ "Gather the results of all Monte Carlo optimizations", "emagefit_3sfd.html#gather", null ],
        [ "Combine the models from Monte Carlo with DOMINO", "emagefit_3sfd.html#domino", null ]
      ] ],
      [ "Analysis", "emagefit_3sfd.html#analysis", null ]
    ] ],
    [ "EMageFit protocol", "emagefit_protocol.html", [
      [ "Input data", "emagefit_protocol.html#input", null ],
      [ "Producing models", "emagefit_protocol.html#models", [
        [ "Pairwise dockings", "emagefit_protocol.html#docking", null ],
        [ "Obtain models with Simulated annealing Monte Carlo optimization", "emagefit_protocol.html#montecarlo", null ],
        [ "Gather the results of all Monte Carlo optimizations", "emagefit_protocol.html#gather", null ],
        [ "Combine the models from Monte Carlo with DOMINO", "emagefit_protocol.html#domino", null ],
        [ "Visualizing the models and understanding the information in the database of solutions", "emagefit_protocol.html#db", null ]
      ] ]
    ] ],
    [ "EMageFit scripts and tools", "emagefit_scripts.html", [
      [ "Command line tools", "emagefit_scripts.html#tools", null ],
      [ "IMP.em2d Python package utilities", "emagefit_scripts.html#em2d_pkg", null ],
      [ "IMP.em2d.imp_general Python package utilities", "emagefit_scripts.html#em2d_gen_pkg", null ]
    ] ],
    [ "Factory Index", "factory_index.html", null ],
    [ "Determination of a Nup133 structure with FoXS", "foxs_nup133.html", [
      [ "Introduction", "foxs_nup133.html#intro", null ],
      [ "Setup", "foxs_nup133.html#setup", null ],
      [ "Calculation", "foxs_nup133.html#calc", null ]
    ] ],
    [ "Function Examples", "function_example_index.html", null ],
    [ "Example design discussion", "design_example.html", [
      [ "Original Description", "design_example.html#orig_discr", null ],
      [ "Comments on the original description", "design_example.html#comments_0", null ],
      [ "Design Proposal for Reading", "design_example.html#design_prop_0", null ],
      [ "Implementing Scoring as a IMP::Restraint", "design_example.html#design_prop_1", null ],
      [ "Implementing Scoring as a IMP::PairScore", "design_example.html#design_prop_2", null ],
      [ "Some final thoughts", "design_example.html#final_thoughts", null ]
    ] ],
    [ "Developer Guide", "devguide.html", [
      [ "Getting around", "devguide.html#gettingaround", null ],
      [ "Writing new functions and classes", "devguide.html#usage", null ],
      [ "Managing your own module", "devguide.html#module", null ],
      [ "Debugging and testing your code", "devguide.html#testing", null ],
      [ "Code coverage", "devguide.html#coverage", null ],
      [ "Coding conventions", "devguide.html#codingconventions", [
        [ "Indentation", "devguide.html#indent", [
          [ "Names", "devguide.html#names", null ]
        ] ],
        [ "Passing and storing data", "devguide.html#datastorage", null ],
        [ "Display", "devguide.html#display", null ],
        [ "Errors", "devguide.html#errors", null ],
        [ "Namespaces", "devguide.html#internal_ns", null ]
      ] ],
      [ "Documenting your code", "devguide.html#docs", [
        [ "Scoring", "devguide.html#scoring", null ]
      ] ],
      [ "Writing Examples", "devguide.html#examples", null ],
      [ "Useful Scripts", "devguide.html#scripts", [
        [ "Making a module", "devguide.html#make_module", null ]
      ] ],
      [ "Contributing code back to the repository", "devguide.html#contributing", [
        [ "Submitting a module", "devguide.html#submitting", null ],
        [ "Once you have submitted code", "devguide.html#submitted", null ]
      ] ],
      [ "Cross platform compatibility", "devguide.html#crossplatform", [
        [ "C++ 11", "devguide.html#cxx11", null ]
      ] ],
      [ "Good programming practices", "devguide.html#cpp", [
        [ "General resources", "devguide.html#coding", null ],
        [ "IMP gotchas", "devguide.html#impcoding", null ]
      ] ],
      [ "Exporting code to Python", "devguide.html#swig", null ],
      [ "Profiling your code", "devguide.html#profiling", null ],
      [ "Understanding the internals of IMP", "devguide.html#internals", null ]
    ] ],
    [ "Change History", "recent.html", null ],
    [ "Installation", "installation.html", [
      [ "Building and installing basics", "installation.html#userbuild", null ],
      [ "Prerequisites", "installation.html#prereq", [
        [ "Getting prerequisites on a Mac", "installation.html#mac", null ],
        [ "Getting prerequisites on Windows", "installation.html#windows", null ],
        [ "Getting prerequisites on Linux", "installation.html#linux", null ],
        [ "Optional prerequisites", "installation.html#optional", [
          [ "Doxygen and Dot", "installation.html#Doxygen", null ],
          [ "MODELLER", "installation.html#MODELLER", null ],
          [ "Google Perf Tools", "installation.html#googleperf", null ]
        ] ],
        [ "Where to go next", "installation.html#next", null ]
      ] ]
    ] ],
    [ "Introduction", "introduction.html", [
      [ "The four stage process", "introduction.html#four_stages", null ],
      [ "IMP", "introduction.html#imp_sec", [
        [ "Representation: IMP::Model", "introduction.html#rep", [
          [ "Decorators", "introduction.html#decorators", null ],
          [ "Representing biological molecules", "introduction.html#biom", null ],
          [ "Containers", "introduction.html#containers", null ],
          [ "Constraints and Invariants", "introduction.html#constraints", null ]
        ] ],
        [ "Scoring", "introduction.html#scoring", [
          [ "Restraints", "introduction.html#restraints", null ],
          [ "Scoring functions", "introduction.html#scoref", null ]
        ] ],
        [ "Sampling", "introduction.html#sampling", [
          [ "Optimizers", "introduction.html#optimizers", null ],
          [ "Samplers", "introduction.html#samplers", null ]
        ] ],
        [ "Storing and analysis", "introduction.html#storing", null ],
        [ "Modular structure of IMP", "introduction.html#modular", null ],
        [ "Understanding what is going on", "introduction.html#understanding", [
          [ "Logging", "introduction.html#logging", null ],
          [ "Runtime checks", "introduction.html#checks", null ]
        ] ],
        [ "Conventions", "introduction.html#conventions", [
          [ "Units", "introduction.html#units", null ],
          [ "Names", "introduction.html#names", null ],
          [ "Graphs", "introduction.html#graphs", null ],
          [ "Values and Objects (C++ only)", "introduction.html#values", null ]
        ] ],
        [ "Where to go next", "introduction.html#next", null ]
      ] ]
    ] ],
    [ "Mailing lists", "maillists.html", null ],
    [ "Multithreaded evaluation using OpenMP", "openmp.html", [
      [ "Activating OpenMP", "openmp.html#activating", null ],
      [ "Controlling OpenMP", "openmp.html#controlling", null ],
      [ "Writing code with OpenMP", "openmp.html#code", null ]
    ] ],
    [ "Integrative docking utility programs", "idock_progs.html", null ],
    [ "Docking of PCSK9 with idock", "idock_pcsk9.html", [
      [ "Introduction", "idock_pcsk9.html#intro", null ],
      [ "Setup", "idock_pcsk9.html#setup", null ],
      [ "Calculation", "idock_pcsk9.html#calc", null ],
      [ "Results", "idock_pcsk9.html#results", null ]
    ] ],
    [ "Dependencies between objects", "dependencies.html", null ],
    [ "Module Index", "modules_index.html", "modules_index" ],
    [ "Modeling of 3sfd with multifit", "multifit_3sfd.html", [
      [ "Introduction", "multifit_3sfd.html#intro", null ],
      [ "Setup", "multifit_3sfd.html#setup", null ],
      [ "Create the assembly anchor graph", "multifit_3sfd.html#anchors", null ],
      [ "Fit each protein to the map", "multifit_3sfd.html#fit_fft", null ],
      [ "Create a proteomics restraint file", "multifit_3sfd.html#proteomics", null ],
      [ "Assemble subunits", "multifit_3sfd.html#assemble", null ],
      [ "Visualization", "multifit_3sfd.html#visualization", null ],
      [ "Benchmarking", "multifit_3sfd.html#bench", null ],
      [ "Clustering", "multifit_3sfd.html#cluster", null ],
      [ "Refinement", "multifit_3sfd.html#refine", null ]
    ] ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", "namespacemembers_type" ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", null ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", null ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
".html",
"Decorator_8h.html",
"IMP_container_overview.html",
"PairContainerStatistics_8h_source.html",
"ScoringFunction_8h_source.html",
"Typed_8h.html#a732d4d87831e0b38e37081bcfe348b6d",
"atom_2Hierarchy_8h.html#abbe974bcb01d2f1dc86b33fd48a76fc4",
"classIMP_1_1algebra_1_1BoundingBoxD.html#aa6d7423fbf0540c850c3adba575b4cc4",
"classIMP_1_1algebra_1_1ReferenceFrame3D.html#ac4adf03ce952d182320a9a99709cb728",
"classIMP_1_1atom_1_1Angle.html#afcdd61c7b3589c5ed4bf9980b105e935",
"classIMP_1_1atom_1_1CHARMMResidueTopologyBase.html#aadf17703a67c4701119d2ac558bbbe78",
"classIMP_1_1atom_1_1Hierarchy.html#ad21bb9279754451fbe57bdebd170faf3",
"classIMP_1_1atom_1_1Selection.html#acab45114cc8375dee9bf9ede0e987092",
"classIMP_1_1base_1_1Tracker.html",
"classIMP_1_1container_1_1MinimumQuadScore.html",
"classIMP_1_1core_1_1Centroid.html#a6ad51a840e0fc72aff3314b6f891d013",
"classIMP_1_1core_1_1InBoundingBox3DSingletonPredicate.html#a2c1c6c49df7e48c49911fcd630e1467d",
"classIMP_1_1core_1_1Reference.html#a3110064efee8b0094b5c56dafe6b90f0",
"classIMP_1_1core_1_1XYZR.html#a855ea12dbcaeb5e67250c33b30c998c5",
"classIMP_1_1display_1_1Writer.html#a937338288c81fd127369bffea2bfff3e",
"classIMP_1_1domino_1_1Slice.html#a70118528acacd6664939fe4131de82e7",
"classIMP_1_1em2d_1_1PolarResamplingParameters.html#a9ed7f33d1e101882b1438587369cc937",
"classIMP_1_1em_1_1DensityFillingRestraint.html#a090c6bbb1219998d1869cb003b2dcfd6",
"classIMP_1_1em_1_1FittingSolutions.html#a6ab5809405eef8dbd14c875eaf8d9646",
"classIMP_1_1example_1_1ExampleDecorator.html#a112e84cddc4b161028d835386d92d7a9",
"classIMP_1_1isd_1_1ISDRestraint.html#ab8ba8602d1f3c186822efe3aa8e06d98",
"classIMP_1_1isd_1_1shared__functions_1_1sfo__common.html#a5da2fb4596e59136ef46a012c8055573",
"classIMP_1_1kernel_1_1Optimizer.html#ab36ad141345ae62cbb570bc5eb077d34",
"classIMP_1_1kernel_1_1ScopedSetAttribute.html#ad598d9a4c087653839a07cab998dd849",
"classIMP_1_1misc_1_1LogPairScore.html",
"classIMP_1_1multifit_1_1SettingsData.html",
"classIMP_1_1saxs_1_1Profile.html#abddecb7d710dddeffed89858d17d7f80",
"cnmultifit_2param_8py_source.html",
"devguide.html#usage",
"emagefit_protocol.html#db",
"globals_defs.html",
"kernel_2Constraint_8h.html#a93193609ed13a7b61f9fa802e1137f76",
"kernel_2dependency__graph_8h.html#afb837b61a8f37168de7ec8fcc2bde390",
"kernel_2unary__function__macros_8h_source.html",
"namespacemembers_func.html",
"restrainer_2nup84_complex_in_bead_representation_8py-example.html",
"structIMP_1_1base_1_1Pointer.html",
"tuple__macros_8h.html#a6d7fe6f203dbac49715de5d84ce7a33e"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  var imgNode = document.createElement("img");
  imgNode.style.paddingLeft=(16*level).toString()+'px';
  imgNode.width  = 16;
  imgNode.height = 22;
  imgNode.border = 0;
  if (node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    imgNode.src = node.relpath+"ftv2node.png";
    domNode.appendChild(imgNode);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  if (anchor.parent().attr('class')=='memItemLeft' ||
      anchor.parent().attr('class')=='fieldtype' ||
      anchor.parent().is(':header')) 
  {
    pos = anchor.parent().position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = $(location).attr('hash');
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,window.location.hash,relpath);
     }
  })

  $(window).load(showRoot);
}

