# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED HDF5_LIBRARIES)

set(CHECK_COMPILES_BODY "H5garbage_collect();")

check_compiles("_environment" HDF5 HDF5 "#include <hdf5.h>" "" "hdf5" HDF5_ok)
if("${HDF5_ok}" MATCHES "1")
message(STATUS "Found HDF5 in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("HDF5_PKGCONF" "hdf5")

# Include dir
find_path("HDF5_INCLUDE_DIR"
  NAMES hdf5.h
  PATHS ${HDF5_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib hdf5)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${HDF5_PKGCONF_LIBRARY_DIRS}
)
set("HDF5_LIBRARY" ${HDF5_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(HDF5_PROCESS_INCLUDES HDF5_INCLUDE_DIR)
set(HDF5_PROCESS_LIBS HDF5_LIBRARY)
libfind_process(HDF5)

if ("${HDF5_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${HDF5_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("HDF5 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/HDF5" "ok=False")
else()
  check_compiles("_found" "HDF5" "HDF5" "#include <hdf5.h>" "${HDF5_INCLUDE_DIR}" "${HDF5_LIBRARY}" HDF5_ok_ok)
  if(${HDF5_ok_ok} MATCHES "1")
    message(STATUS "Found HDF5 at ""${HDF5_INCLUDE_DIR}" " " "${HDF5_LIBRARY}")
  else()
    message("HDF5 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/HDF5" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "HDF5 already setup")

endif(NOT DEFINED HDF5_LIBRARIES)