# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED GPerfTools_LIBRARIES)

set(CHECK_COMPILES_BODY "ProfilerStop();")

check_compiles("_environment" GPerfTools GPERFTOOLS "#include <gperftools/profiler.h>" "" "profiler" GPerfTools_ok)
if("${GPerfTools_ok}" MATCHES "1")
message(STATUS "Found GPerfTools in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("GPerfTools_PKGCONF" "gperftools")

# Include dir
find_path("GPerfTools_INCLUDE_DIR"
  NAMES gperftools/profiler.h
  PATHS ${GPerfTools_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib profiler)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${GPerfTools_PKGCONF_LIBRARY_DIRS}
)
set("GPerfTools_LIBRARY" ${GPerfTools_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(GPerfTools_PROCESS_INCLUDES GPerfTools_INCLUDE_DIR)
set(GPerfTools_PROCESS_LIBS GPerfTools_LIBRARY)
libfind_process(GPerfTools)

if ("${GPerfTools_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${GPerfTools_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("GPerfTools not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/GPerfTools" "ok=False")
else()
  check_compiles("_found" "GPerfTools" "GPERFTOOLS" "#include <gperftools/profiler.h>" "${GPerfTools_INCLUDE_DIR}" "${GPerfTools_LIBRARY}" GPerfTools_ok_ok)
  if(${GPerfTools_ok_ok} MATCHES "1")
    message(STATUS "Found GPerfTools at ""${GPerfTools_INCLUDE_DIR}" " " "${GPerfTools_LIBRARY}")
  else()
    message("GPerfTools not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/GPerfTools" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "GPerfTools already setup")

endif(NOT DEFINED GPerfTools_LIBRARIES)