/**
 *  \file IMP/core/ClassnameConstraint.h
 *  \brief Use a ClassnameModifier applied to a PLURALVARIABLETYPE to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2013 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_CLASSNAME_CONSTRAINT_H
#define IMPCORE_CLASSNAME_CONSTRAINT_H

#include <IMP/core/core_config.h>
#include <IMP/internal/TupleConstraint.h>
#include <IMP/ClassnameModifier.h>
#include <IMP/ClassnameDerivativeModifier.h>
#include <IMP/score_state_macros.h>

IMPCORE_BEGIN_NAMESPACE
//! Apply a ClassnameFunction to a Classname
/** The score state is passed up to two ClassnameModifiers, one to
    apply before evaluation and the other after. The one after
    should take a DerivativeAccumulator as its last argument for
    ClassnameModifier::apply() and will only be called if
    the score was computed with derivatives.

    \see container::ClassnamesConstraint
 */
class ClassnameConstraint :
#if defined(IMP_DOXYGEN) || defined(SWIG)
public Constraint
#else
public IMP::kernel::internal::TupleConstraint<ClassnameModifier,
                                      ClassnameDerivativeModifier>
#endif
{
public:
  /** before and after are the modifiers to apply before and after
      evaluate.
   */
  ClassnameConstraint(ClassnameModifier *before,
                      ClassnameDerivativeModifier *after,
                      ARGUMENTTYPE vt,
                      std::string name="ClassnameConstraint %1%"):
      IMP::kernel::internal::TupleConstraint<ClassnameModifier,
                                      ClassnameDerivativeModifier>
      (before, after, vt, name)
      {
  }

#if defined(IMP_DOXYGEN) || defined(SWIG)
  protected:
  void do_update_attributes();
  void do_update_derivatives(DerivativeAccumulator *da);
  virtual ModelObjectsTemp do_get_inputs() const;
  virtual ModelObjectsTemp do_get_outputs() const;
  IMP_OBJECT_METHODS(ClassnameConstraint);
#endif
};


IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_CLASSNAME_CONSTRAINT_H */
