# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED FFTW3_LIBRARIES)

set(CHECK_COMPILES_BODY "")

check_compiles("_environment" FFTW3 FFTW3 "#include <fftw3.h>" "" "fftw3" FFTW3_ok)
if("${FFTW3_ok}" MATCHES "1")
message(STATUS "Found FFTW3 in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("FFTW3_PKGCONF" "fftw3")

# Include dir
find_path("FFTW3_INCLUDE_DIR"
  NAMES fftw3.h
  PATHS ${FFTW3_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib fftw3)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${FFTW3_PKGCONF_LIBRARY_DIRS}
)
set("FFTW3_LIBRARY" ${FFTW3_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(FFTW3_PROCESS_INCLUDES FFTW3_INCLUDE_DIR)
set(FFTW3_PROCESS_LIBS FFTW3_LIBRARY)
libfind_process(FFTW3)

if ("${FFTW3_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${FFTW3_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("FFTW3 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/FFTW3" "ok=False")
else()
  check_compiles("_found" "FFTW3" "FFTW3" "#include <fftw3.h>" "${FFTW3_INCLUDE_DIR}" "${FFTW3_LIBRARY}" FFTW3_ok_ok)
  if(${FFTW3_ok_ok} MATCHES "1")
    message(STATUS "Found FFTW3 at ""${FFTW3_INCLUDE_DIR}" " " "${FFTW3_LIBRARY}")
  else()
    message("FFTW3 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/FFTW3" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "FFTW3 already setup")

endif(NOT DEFINED FFTW3_LIBRARIES)