# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED Eigen3_LIBRARIES)

set(CHECK_COMPILES_BODY "")

check_compiles("_environment" Eigen3 EIGEN3 "#include <Eigen/Core>" "" "" Eigen3_ok)
if("${Eigen3_ok}" MATCHES "1")
message(STATUS "Found Eigen3 in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("Eigen3_PKGCONF" "eigen3")

# Include dir
find_path("Eigen3_INCLUDE_DIR"
  NAMES Eigen/Core
  PATHS ${Eigen3_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib )
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${Eigen3_PKGCONF_LIBRARY_DIRS}
)
set("Eigen3_LIBRARY" ${Eigen3_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(Eigen3_PROCESS_INCLUDES Eigen3_INCLUDE_DIR)
set(Eigen3_PROCESS_LIBS Eigen3_LIBRARY)
libfind_process(Eigen3)

if ("${Eigen3_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${Eigen3_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("Eigen3 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/Eigen3" "ok=False")
else()
  check_compiles("_found" "Eigen3" "EIGEN3" "#include <Eigen/Core>" "${Eigen3_INCLUDE_DIR}" "${Eigen3_LIBRARY}" Eigen3_ok_ok)
  if(${Eigen3_ok_ok} MATCHES "1")
    message(STATUS "Found Eigen3 at ""${Eigen3_INCLUDE_DIR}" " " "${Eigen3_LIBRARY}")
  else()
    message("Eigen3 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/Eigen3" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "Eigen3 already setup")

endif(NOT DEFINED Eigen3_LIBRARIES)