# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED GSL_LIBRARIES)

set(CHECK_COMPILES_BODY "gsl_sf_bessel_J0(1.0);")

check_compiles("_environment" GSL GSL "#include <gsl/gsl_sf_bessel.h>" "" "gsl
gslcblas" GSL_ok)
if("${GSL_ok}" MATCHES "1")
message(STATUS "Found GSL in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("GSL_PKGCONF" "gsl")

# Include dir
find_path("GSL_INCLUDE_DIR"
  NAMES gsl/gsl_sf_bessel.h
  PATHS ${GSL_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib gsl
gslcblas)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${GSL_PKGCONF_LIBRARY_DIRS}
)
set("GSL_LIBRARY" ${GSL_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(GSL_PROCESS_INCLUDES GSL_INCLUDE_DIR)
set(GSL_PROCESS_LIBS GSL_LIBRARY)
libfind_process(GSL)

if ("${GSL_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${GSL_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("GSL not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/GSL" "ok=False")
else()
  check_compiles("_found" "GSL" "GSL" "#include <gsl/gsl_sf_bessel.h>" "${GSL_INCLUDE_DIR}" "${GSL_LIBRARY}" GSL_ok_ok)
  if(${GSL_ok_ok} MATCHES "1")
    message(STATUS "Found GSL at ""${GSL_INCLUDE_DIR}" " " "${GSL_LIBRARY}")
  else()
    message("GSL not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/GSL" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "GSL already setup")

endif(NOT DEFINED GSL_LIBRARIES)