# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED OpenCV21_LIBRARIES)

set(CHECK_COMPILES_BODY "BOOST_STATIC_ASSERT( CV_MAJOR_VERSION==2 && CV_MINOR_VERSION==1); new cv::Mat();")

check_compiles("_environment" OpenCV21 OPENCV21 "#include <opencv/cv.h>
#include <opencv/cvver.h>
#include <boost/static_assert.hpp>" "" "cv
cxcore
highgui" OpenCV21_ok)
if("${OpenCV21_ok}" MATCHES "1")
message(STATUS "Found OpenCV21 in environment")
else()
include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("OpenCV21_PKGCONF" "opencv21")

# Include dir
find_path("OpenCV21_INCLUDE_DIR"
  NAMES opencv/cv.h
opencv/cvver.h
boost/static_assert.hpp
  PATHS ${OpenCV21_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib cv
cxcore
highgui)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${OpenCV21_PKGCONF_LIBRARY_DIRS}
)
set("OpenCV21_LIBRARY" ${OpenCV21_LIBRARY} ${${lib}_LIBRARY})
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(OpenCV21_PROCESS_INCLUDES OpenCV21_INCLUDE_DIR)
set(OpenCV21_PROCESS_LIBS OpenCV21_LIBRARY)
libfind_process(OpenCV21)

if ("${OpenCV21_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${OpenCV21_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("OpenCV21 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/OpenCV21" "ok=False")
else()
  check_compiles("_found" "OpenCV21" "OPENCV21" "#include <opencv/cv.h>
#include <opencv/cvver.h>
#include <boost/static_assert.hpp>" "${OpenCV21_INCLUDE_DIR}" "${OpenCV21_LIBRARY}" OpenCV21_ok_ok)
  if(${OpenCV21_ok_ok} MATCHES "1")
    message(STATUS "Found OpenCV21 at ""${OpenCV21_INCLUDE_DIR}" " " "${OpenCV21_LIBRARY}")
  else()
    message("OpenCV21 not found")
file(WRITE "${PROJECT_BINARY_DIR}/data/build_info/OpenCV21" "ok=False")
  endif()
endif()
endif()
else()
message(STATUS "OpenCV21 already setup")

endif(NOT DEFINED OpenCV21_LIBRARIES)