/**
 *  \file AllBipartitePairContainer.cpp   \brief A list of ParticlePairs.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2013 IMP Inventors. AllBipartite rights reserved.
 *
 */

#include "IMP/container/AllBipartitePairContainer.h"
#include <IMP/PairModifier.h>
#include <IMP/SingletonModifier.h>
#include <IMP/PairScore.h>
#include <IMP/SingletonScore.h>
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

AllBipartitePairContainer
::AllBipartitePairContainer( SingletonContainerAdaptor a,
                             SingletonContainerAdaptor b,
                             std::string name):
  PairContainer(a->get_model(), name),
  a_(a), b_(b) {
}

ParticleIndexPairs
AllBipartitePairContainer::get_indexes() const {
  ParticleIndexes ia= a_->get_indexes();
  ParticleIndexes ib= b_->get_indexes();
  ParticleIndexPairs ret; ret.reserve(ia.size()*ib.size());
  for (unsigned int i=0; i< ia.size(); ++i) {
    for (unsigned int j=0; j< ib.size(); ++j) {
      ret.push_back(ParticleIndexPair(ia[i], ib[j]));
    }
  }
  return ret;
}

ParticleIndexPairs
AllBipartitePairContainer::get_range_indexes() const {
  ParticleIndexes ia= a_->get_range_indexes();
  ParticleIndexes ib= b_->get_range_indexes();
  ParticleIndexPairs ret; ret.reserve(ia.size()*ib.size());
  for (unsigned int i=0; i< ia.size(); ++i) {
    for (unsigned int j=0; j< ib.size(); ++j) {
      ret.push_back(ParticleIndexPair(ia[i], ib[j]));
    }
  }
  return ret;
}

void AllBipartitePairContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out << "container " << *a_ << " and " << *b_ << std::endl;
}

ParticleIndexes AllBipartitePairContainer::get_all_possible_indexes() const {
  ParticleIndexes ret= a_->get_all_possible_indexes();
  ret+= b_->get_all_possible_indexes();
  return ret;
}

ParticlesTemp AllBipartitePairContainer::get_input_particles() const {
  return ParticlesTemp();
}

ContainersTemp AllBipartitePairContainer::get_input_containers() const {
  ContainersTemp ret;
  ret.push_back(a_);
  ret.push_back(b_);
  return ret;
}

void AllBipartitePairContainer::do_before_evaluate() {
  set_is_changed(a_->get_is_changed() || b_->get_is_changed());
}

IMPCONTAINER_END_NAMESPACE
