/**
 *  \file IMP/container/InContainerTripletFilter.h
 *  \brief A filter for Triplets.
 *
 *  This file is generated by a script (core/tools/make-containers).
 *  Do not edit directly.
 *
 *  Copyright 2007-2013 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_IN_CONTAINER_TRIPLET_FILTER_H
#define IMPCONTAINER_IN_CONTAINER_TRIPLET_FILTER_H

#include <IMP/container/container_config.h>
#include <IMP/TripletPredicate.h>
#include <IMP/TripletContainer.h>
#include <IMP/internal/container_helpers.h>
#include "internal/TripletContainerIndex.h"
#include <IMP/triplet_macros.h>
#include <IMP/base/warning_macros.h>

IMPCONTAINER_BEGIN_NAMESPACE


//! A filter which returns true if a container containers the Triplet
/** This predicate returns 1 if the passed tuple is in the container.
    \note Use the handle_permutations parameter to the constructor to
    determine whether only exact matchers, or matches under permutation
    are considered matching. By default they are are.
 */
class IMPCONTAINEREXPORT InContainerTripletFilter :
    public TripletPredicate
{
  IMP::base::OwnerPointer<internal::TripletContainerIndex> c_;
public:
  InContainerTripletFilter(TripletContainer *c,
                             std::string name="TripletFilter %1%");
  InContainerTripletFilter(TripletContainer *c,
                             bool handle_permutations,
                             std::string name="TripletFilter %1%");

  IMP_INDEX_TRIPLET_PREDICATE(InContainerTripletFilter,{
      IMP_UNUSED(m);
      return c_->get_contains(pi);
    },{
      ModelObjectsTemp ret;
      ret+= IMP::get_particles(m, pi);
      ret.push_back(c_);
      return ret;
    });
};


IMP_OBJECTS(InContainerTripletFilter, InContainerTripletFilters);

IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_IN_CONTAINER_TRIPLET_FILTER_H */
