Name:          imp
Version:       1.0
Release:       1%{?dist}
License:       LGPLv2+ and GPLv3
Summary:       The Integrative Modeling Platform
Group:         Applications/Engineering
Packager:      Ben Webb <ben@salilab.org>
URL:           http://www.integrativemodeling.org/
Source0:       %{name}-%{version}.tar.gz
BuildRoot:     %{_tmppath}/%{name}-%{version}-root
BuildRequires: scons >= 0.98, boost-devel, swig, python-devel
BuildRequires: modeller

# RHEL doesn't have a CGAL package, so build without CGAL on RHEL; on Fedora,
# add it in as a dependency
%if 0%{?fedora}
BuildRequires: CGAL-devel
%define cgal_opts cgal=yes
%else
%define cgal_opts cgal=no
%endif

%define scons_opts %{cgal_opts} modeller=/usr/

# RHEL5 on IA64 doesn't like building the debug package
%ifnarch ia64
%define debug_package %{nil}
%endif

%description
IMP's broad goal is to contribute to a comprehensive structural
characterization of biomolecules ranging in size and complexity from small
peptides to large macromolecular assemblies. Detailed structural
characterization of assemblies is generally impossible by any single existing
experimental or computational method. This barrier can be overcome by hybrid
approaches that integrate data from diverse biochemical and biophysical
experiments (eg, x-ray crystallography, NMR spectroscopy, electron microscopy,
immuno-electron microscopy, footprinting, chemical cross-linking, FRET
spectroscopy, small angle X-ray scattering, immunoprecipitation, genetic
interactions, etc...).

We formulate the hybrid approach to structure determination as an optimization
problem, the solution of which requires three main components:
    * the representation of the assembly,
    * the scoring function and
    * the optimization method.

The ensemble of solutions to the optimization problem embodies the most
accurate structural characterization given the available information.

We created IMP, the Integrative Modeling Platform, to make it easier to
implement such an integrative approach to structural and dynamics problems.
IMP is designed to allow mixing and matching of existing modeling components
as well as easy addition of new functionality.

%package devel
Group:         Applications/Engineering
Summary:       Development package for IMP developers.
Requires:      %{name} = %{version}-%{release}

%description devel
This package contains the include files for building applications that link
against IMP.

%package python
Group:         Applications/Engineering
Summary:       Python bindings for IMP.
Requires:      %{name} = %{version}-%{release}

%description python
This package contains Python bindings for IMP, to allow IMP functionality to
be used from Python.

%prep
%setup

%build

%install
scons destdir=${RPM_BUILD_ROOT} %{scons_opts} install
# Note that we currently don't include the documentation in the RPM, since
#      a) it takes a long time to run doxygen
#      b) doxygen isn't installed on all of our build systems
#      c) it is really big
#  and d) only certain versions of doxygen work correctly
# You can build the documentation by running, in the IMP source tree:
# scons dot=True destdir=/tmp docdir=/usr/share/doc/imp-1.0 doc-install
README=${RPM_BUILD_ROOT}/usr/share/doc/%{name}-%{version}/README
echo "For full IMP documentation, please go to" > ${README}
echo "http://salilab.org/imp/%{version}/doc/html/" >> ${README}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%dir /usr/share/doc/%{name}-%{version}
%doc /usr/share/doc/%{name}-%{version}/examples
/usr/share/imp
/usr/bin/*
%{_libdir}/libimp*.so

%files devel
%defattr(-,root,root)
/usr/include/IMP
/usr/include/IMP.h

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/IMP
%{_libdir}/python*/site-packages/_IMP*so

%changelog
* Mon Mar 08 2010 Ben Webb <ben@salilab.org>   1.0-1
- 1.0 release.

* Thu May 07 2009 Ben Webb <ben@salilab.org>
- Initial build.
