# NOTE: This file is generated from modules/core/tools/container_tempates/test.py
# do not edit.

import unittest
import IMP
import IMP.test
import IMP.core
import IMP.container
import math

def compare(a,b):
    return cmp(a.get_name(), b.get_name())

# This file is generated by the make-container script

class ClassnameContainerTest(IMP.test.TestCase):
    """Tests for GroupnameContainer related objects"""

    def create_particle(self,m):
        p= IMP.Particle(m)
        d=IMP.core.XYZ.setup_particle(p)
        d.set_coordinates(IMP.algebra.get_random_vector_in(IMP.algebra.get_unit_bounding_box_3d()))
        p.add_attribute(IMP.FloatKey("thekey"), d.get_x())
        return p

    def create_particle_pair(self,m):
        p0= IMP.Particle(m)
        p1= IMP.Particle(m)
        d0= IMP.core.XYZ.setup_particle(p0)
        d1= IMP.core.XYZ.setup_particle(p1)
        d0.set_coordinates(IMP.algebra.get_random_vector_in(IMP.algebra.get_unit_bounding_box_3d()))
        d1.set_coordinates(IMP.algebra.get_random_vector_in(IMP.algebra.get_unit_bounding_box_3d()))
        return IMP.ParticlePair(p0,p1)

    def create_singleton_score(self):
        uf= IMP.core.Linear(0,1)
        return IMP.core.AttributeSingletonScore(uf,IMP.FloatKey("thekey"))

    def create_pair_score(self):
        uf= IMP.core.Linear(0,1)
        return IMP.core.DistancePairScore(uf)

    def create_singleton_restraint(self, ps,p):
        return IMP.core.SingletonRestraint(ps, p)

    def create_pair_restraint(self, ps, p):
        return IMP.core.PairRestraint(ps, IMP.ParticlePair(p[0], p[1]))


    def test_restraint(self):
        """Test the GroupnamesRestraint"""
        m= IMP.Model()
        gs=self.create_groupname_score()
        c= IMP.container.ListGroupnameContainer()
        f=0
        for i in range(0,10):
            p=self.create_classname(m)
            f= f+ gs.evaluate(p, None)
            c.add_classname(p)
            r= IMP.container.GroupnamesRestraint(gs, c)
            r.set_was_used(True)
        m.add_restraint(r)
        self.assertInTolerance(m.evaluate(False), f, .1*f)
        p=self.create_classname(m)
        f= f+ gs.evaluate(p,None)
        c.add_classname(p)
        self.assertInTolerance(m.evaluate(False), f, .1*f)


    def test_irestraint(self):
        """Test the incremental evaluation of the GroupnamesRestraint"""
        m= IMP.Model()
        m.set_log_level(IMP.TERSE)
        gs=self.create_groupname_score()
        c= IMP.container.ListGroupnameContainer()
        ps=IMP.Classnames()
        ps2= IMP.Classnames()
        f=0
        for i in range(0,20):
            p=self.create_classname(m)
            ps.append(p)
            f=f+gs.evaluate(p,None)
        for i in range(0,10):
            p=self.create_classname(m)
            ps2.append(p)
            #f=f+evaluate_groupname_score(gs, p)
        c.set_classnames(ps)
        r= IMP.container.GroupnamesRestraint(gs, c)
        m.add_restraint(r)
        m.set_is_incremental(True)
        self.assertInTolerance(m.evaluate(False), f, .1*f)
        self.assertInTolerance(m.evaluate(False), f, .1*f)
        ps= ps+ps2
        f=0
        for p in ps:
            f=f+ gs.evaluate(p,None)
        c.set_classnames(ps)
        self.assertInTolerance(m.evaluate(False), f, .1*f)


    def test_srestraint(self):
        """Test the GroupnameRestraint"""
        m= IMP.Model()
        gs=self.create_groupname_score()
        p=self.create_classname(m)
        f= gs.evaluate(p, None)
        r= self.create_groupname_restraint(gs, p)
        r.set_was_used(True)
        m.add_restraint(r)
        self.assertInTolerance(m.evaluate(False), f, .1*f)

    def test_min_restraint(self):
        """Test the MinimumGroupnameRestraint"""
        m= IMP.Model()
        c= IMP.container.ListGroupnameContainer()
        self.assertEqual(c.get_ref_count(), 1)
        for i in range(0,10):
            c.add_classname(self.create_classname(m))
        print c.get_number_of_classnames()
        d= self.create_groupname_score()
        self.assertEqual(d.get_ref_count(), 1)
        r= IMP.container.MinimumGroupnameRestraint(d, c)
        self.assertEqual(d.get_ref_count(), 2)
        self.assertEqual(c.get_ref_count(), 2)
        r.set_n(4)
        m.add_restraint(r)
        f= m.evaluate(False)
        print f
        ms= []
        print c.get_number_of_classnames()
        for i in range(0,10):
            ps= c.get_classname(i)
            cm= d.evaluate(ps, None)
            ms.append(cm)
        print ms
        ms.sort()
        mt=0
        for i in range(0, 4):
            mt = mt+ ms[i]
        print mt
        self.assertInTolerance(mt, f, .1*f)

    def test_max_restraint(self):
        """Test the MaximumGroupnameRestraint"""
        m= IMP.Model()
        c= IMP.container.ListGroupnameContainer()
        self.assertEqual(c.get_ref_count(), 1)
        for i in range(0,10):
            c.add_classname(self.create_classname(m))
        print c.get_number_of_classnames()
        d= self.create_groupname_score()
        self.assertEqual(d.get_ref_count(), 1)
        r= IMP.container.MaximumGroupnameRestraint(d, c)
        self.assertEqual(c.get_ref_count(), 2)
        self.assertEqual(d.get_ref_count(), 2)
        r.set_n(4)
        m.add_restraint(r)
        f= m.evaluate(False)
        print f
        ms= []
        print c.get_number_of_classnames()
        for i in range(0,10):
            ps= c.get_classname(i)
            cm= d.evaluate(ps, None)
            ms.append(cm)
        ms.sort()
        print ms
        mt=0
        for i in range(0, 4):
            mt = mt+ ms[-i-1]
        print mt
        self.assertInTolerance(mt, f, .1*f)
    def test_max_score(self):
        """Test the MaximumGroupnameScore"""
        m= IMP.Model()
        s= IMP.GroupnameScoresTemp()
        for i in range(0,5):
            s.append(IMP.test.ConstGroupnameScore(i))
        ps= IMP.container.MaximumGroupnameScore(s, 2)
        p= self.create_classname(m)
        ps.set_was_used(True)
        v= ps.evaluate(p, None)
        self.assertEqual(v, 7)
    def test_min_score(self):
        """Test the MinimumGroupnameScore"""
        m= IMP.Model()
        s= IMP.GroupnameScoresTemp()
        for i in range(0,5):
            s.append(IMP.test.ConstGroupnameScore(i))
        ps= IMP.container.MinimumGroupnameScore(s, 3)
        p= self.create_classname(m)
        ps.set_was_used(True)
        v= ps.evaluate(p, None)
        self.assertEqual(v, 3)

    def test_set(self):
        """Testing GroupnameContainerSet"""
        IMP.set_log_level(IMP.VERBOSE)
        m= IMP.Model()
        print "hi"
        c= IMP.container.GroupnameContainerSet()
        ls=[]
        cs=[]
        for i in range(0,3):
            l= IMP.container.ListGroupnameContainer()
            c.add_groupname_container(l)
            for j in range(0,3):
                t=self.create_classname(m)
                l.add_classname(t)
                cs.append(t)
        for p in cs:
            self.assert_(c.get_contains_classname(p))
        ret=[]
        for i in range(0, len(cs)):
            ret.append(c.get_classname(i))
        ret.sort(compare)
        #print ret
        cs.sort(compare)
        #rint cs
        for i in range(0, len(ret)):
            self.assertEqual(compare(ret[i], cs[i]), 0)
        self.assertEqual(c.get_number_of_classnames(), len(cs))

if __name__ == '__main__':
    unittest.main()
