/**
 *  \file GroupnamesConstraint.h
 *  \brief Use a GroupnameModifier applied to a Classnames to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_GROUPNAMES_CONSTRAINT_H
#define IMPCONTAINER_GROUPNAMES_CONSTRAINT_H

#include "container_config.h"
#include <IMP/GroupnameContainer.h>
#include <IMP/GroupnameModifier.h>
#include <IMP/Constraint.h>

IMP_BEGIN_NAMESPACE
// for swig
class GroupnameContainer;
class GroupnameModifier;
IMP_END_NAMESPACE

IMPCONTAINER_BEGIN_NAMESPACE
//! Apply a GroupnameFunction to a GroupnameContainer to maintain an invariant
/** The score state is passed up to two GroupnameModifiers, one to
    apply before evaluation and the other after. The one after
    should take a DerivativeAccumulator as its last argument for
    GroupnameModifier::apply() and will only be called if
    the score was computed with derivatives.

    An example showing a how to use such a score state to maintain a cover
    of the atoms of a protein by a sphere per residue.
    \verbinclude cover_particles.py

    \see GroupnameConstraint
 */
class IMPCONTAINEREXPORT GroupnamesConstraint : public Constraint
{
  IMP::internal::OwnerPointer<GroupnameModifier> f_;
  IMP::internal::OwnerPointer<GroupnameModifier> af_;
  IMP::internal::OwnerPointer<GroupnameContainer> c_;
public:
  /** \param[in] c The Container to hold the elements to process
      \param[in] before The GroupnameModifier to apply to all elements
      before evaluate.
      \param[in] after The GroupnameModifier to apply to all elements
      after evaluate.
      \param[in] name The object name
   */
  GroupnamesConstraint(GroupnameContainer *c, GroupnameModifier *before,
                       GroupnameModifier *after,
                       std::string name="GroupnameConstraint %1%");

  //! Apply this modifier to all the elements after an evaluate
  void set_after_evaluate_modifier(GroupnameModifier* f) {
    af_=f;
  }

  //! Apply this modifier to all the elements before an evaluate
  void set_before_evaluate_modifier(GroupnameModifier* f) {
    f_=f;
  }

  IMP_CONSTRAINT(GroupnamesConstraint);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_GROUPNAMES_CONSTRAINT_H */
