/**
 *  \file GroupnameRestraint.h
 *  \brief Apply a GroupnameScore to a Classname.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_GROUPNAME_RESTRAINT_H
#define IMPCORE_GROUPNAME_RESTRAINT_H

#include "core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/GroupnameScore.h>

#include <iostream>

IMPCORE_BEGIN_NAMESPACE

//! Applies a GroupnameScore to a Classname.
/** This restraint stores a Classname.
    \see GroupnameRestraint
 */
class IMPCOREEXPORT GroupnameRestraint : public Restraint
{
  IMP::internal::OwnerPointer<GroupnameScore> ss_;
  StoreValue v_;
  mutable double score_;
public:
  //! Create the restraint.
  /** This function takes the function to apply to the
      stored Groupname and the Groupname.
   */
  GroupnameRestraint(GroupnameScore *ss,
                     PassValue vt,
                     std::string name="GroupnameRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(GroupnameRestraint);
};

IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_GROUPNAME_RESTRAINT_H */
