/**
 *  \file GroupnamesOptimizerState.h
 *  \brief Use a GroupnameModifier applied to a Classnames to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_GROUPNAMES_OPTIMIZER_STATE_H
#define IMPCONTAINER_GROUPNAMES_OPTIMIZER_STATE_H

#include "container_config.h"
#include <IMP/GroupnameContainer.h>
#include <IMP/GroupnameModifier.h>
#include <IMP/OptimizerState.h>

IMP_BEGIN_NAMESPACE
// for swig
class GroupnameContainer;
class GroupnameModifier;
IMP_END_NAMESPACE

IMPCONTAINER_BEGIN_NAMESPACE
//! Apply a GroupnameFunction to a GroupnameContainer to maintain an invariant
/** \ingroup restraint
    \see GroupnameOptimizerState
 */
class IMPCONTAINEREXPORT GroupnamesOptimizerState : public OptimizerState
{
  IMP::internal::OwnerPointer<GroupnameModifier> f_;
  IMP::internal::OwnerPointer<GroupnameContainer> c_;
public:
  /** \param[in] c The Container to hold the elements to process
      \param[in] gf The GroupnameModifier to apply to all elements.
      \param[in] name The name to use for this Object
   */
  GroupnamesOptimizerState(GroupnameContainer *c, GroupnameModifier *gf,
                           std::string name="GroupnamesOptimizerState %1%");

  IMP_OPTIMIZER_STATE(GroupnamesOptimizerState);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_GROUPNAMES_OPTIMIZER_STATE_H */
