/**
 *  \file GroupnamesOptimizerState.cpp
 *  \brief Use a GroupnameModifier applied to a GroupnameContainer to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/GroupnamesOptimizerState.h"
#include <utility>

IMPCONTAINER_BEGIN_NAMESPACE

GroupnamesOptimizerState
::GroupnamesOptimizerState(GroupnameContainer *c,
                           GroupnameModifier *gm,
                           std::string name):
  OptimizerState(name),
  c_(c)
{
  f_=gm;
}


void GroupnamesOptimizerState::update()
{
  IMP_OBJECT_LOG;
  if (!f_) return;
  IMP_LOG(TERSE, "Begin GroupnamesOptimizerState::update" << std::endl);
  IMP_CHECK_OBJECT(f_);
  IMP_CHECK_OBJECT(c_);
  ClassnamesTemp set =c_->get_classnames();
  f_->apply(set);

  IMP_LOG(TERSE, "End GroupnamesOptimizerState::update" << std::endl);
}



void GroupnamesOptimizerState::do_show(std::ostream &out) const {
}

IMPCONTAINER_END_NAMESPACE
