/**
 *  \file ListGroupnameContainer.cpp   \brief A list of Classnames.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/ListGroupnameContainer.h"
#include "IMP/GroupnameModifier.h"
#include "IMP/GroupnameScore.h"
#include <IMP/core/internal/groupname_helpers.h>
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

ListGroupnameContainer
::ListGroupnameContainer(bool):
  P(true){}

ListGroupnameContainer
::ListGroupnameContainer(const Classnames &ps,
                         std::string name):
  P(name)
{
  if (ps.empty()) return;
  for (unsigned int i=0; i< ps.size(); ++i) {
    IMP_USAGE_CHECK(IMP::internal::is_valid(ps[i]),
                    "Passed Classname cannot be NULL (or None)");
    IMP_USAGE_CHECK(IMP::internal::get_model(ps[i])
                    == IMP::internal::get_model(ps[0]),
                    "All particles in container must have the same model. "
                    << "Particle " << IMP::internal::get_name(ps[i])
                    << " does not.");
  }
  set_classnames(ps);
}

ListGroupnameContainer
::ListGroupnameContainer(std::string name):
  P(name){
}

ListGroupnameContainer
::ListGroupnameContainer(const char *name):
  P(name){
}

void ListGroupnameContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out <<  get_number_of_classnames()
      << " classnames" << std::endl;
}

IMPCONTAINER_END_NAMESPACE
