/**
 *  \file RemoveInactiveGroupnamesOptimizerState.h
 *  \brief Use a GroupnameModifier applied to a Classnames to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_REMOVE_INACTIVE_GROUPNAMES_OPTIMIZER_STATE_H
#define IMPCONTAINER_REMOVE_INACTIVE_GROUPNAMES_OPTIMIZER_STATE_H

#include "config.h"
#include <IMP/core/ListGroupnameContainer.h>
#include <IMP/OptimizerState.h>

IMPCONTAINER_BEGIN_NAMESPACE


//! Remove inactive Groupnames from a list
/** This optimizer state can be used to clean up particles which have
    been inactived by other OptimizaterState objects.

    \ingroup restraint
    \see GroupnameOptimizerState
 */
class IMPCONTAINEREXPORT RemoveInactiveGroupnamesOptimizerState :
  public OptimizerState
{
  IMP::internal::OwnerPointer<ListGroupnameContainer> c_;
public:
  /** \param[in] c The Container to hold the elements to process
      \param[in] name The name to use for this Object
   */
  RemoveInactiveGroupnamesOptimizerState(ListGroupnameContainer *c,
                                         std::string name
                                         ="RemoveInactive %1%");

  IMP_OPTIMIZER_STATE(RemoveInactiveGroupnamesOptimizerState,
                      get_module_version_info())
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_REMOVE_INACTIVE_GROUPNAMES_OPTIMIZER_STATE_H */
