/**
 *  \file RemoveInactiveGroupnamesOptimizerState.cpp
 *  \brief Use a GroupnameModifier applied to a GroupnameContainer to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/core/RemoveInactiveGroupnamesOptimizerState.h"
#include "IMP/internal/container_helpers.h"
#include <utility>

IMPCONTAINER_BEGIN_NAMESPACE

RemoveInactiveGroupnamesOptimizerState
::RemoveInactiveGroupnamesOptimizerState(ListGroupnameContainer *c,
                                         std::string name):
  OptimizerState(name),
  c_(c){
}

namespace {
  struct Inactive {
    bool operator()(Value c) const {
      return IMP::internal::ContainerTraits<Classname>::is_inactive(c);
    }
  };
}

void RemoveInactiveGroupnamesOptimizerState::update()
{
  IMP_OBJECT_LOG;
  IMP_LOG(TERSE, "Begin RemoveInactiveGroupnamesOptimizerState::update"
          << std::endl);
  IMP_CHECK_OBJECT(c_);
  c_->remove_classnames_if(Inactive());

  IMP_LOG(TERSE, "End RemoveInactiveGroupnamesOptimizerState::update"
          << std::endl);
}



void RemoveInactiveGroupnamesOptimizerState::show(std::ostream &out) const {
  out << "RemoveInactiveGroupnamesOptimizerState" << std::endl;
}

IMPCONTAINER_END_NAMESPACE
