/**
 *  \file GroupnameFilter.h    \brief A filter for classnames.
 *
 *  This file is generated by a script (core/tools/make-containers).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMP_GROUPNAME_FILTER_H
#define IMP_GROUPNAME_FILTER_H

#include "kernel_config.h"
#include "Particle.h"
#include "utility.h"
#include "VersionInfo.h"
#include "base_types.h"
#include "VersionInfo.h"

IMP_BEGIN_NAMESPACE


//! A shared filter for classnames
/** Stores a searchable shared collection of classnames.
    \ingroup restraints

    Implementors should see IMP_GROUPNAME_FILTER().
 */
class IMPEXPORT GroupnameFilter : public Object
{
public:
  GroupnameFilter(std::string name="GroupnameFilter %1%");

  /** \note This function may be linear. Be aware of the complexity
      bounds of your particular filter.
   */
  virtual bool get_contains_classname(PassValue p) const =0;

  /** \name Interactions
      Return the set of particles used when applied to the passed
      list.
      @{
  */
  virtual ParticlesTemp get_input_particles(PassValue p) const=0;
  virtual ObjectsTemp get_input_objects(PassValue p) const=0;
  /** @} */

  IMP_REF_COUNTED_DESTRUCTOR(GroupnameFilter);
};

IMP_OUTPUT_OPERATOR(GroupnameFilter);

IMP_OBJECTS(GroupnameFilter);

IMP_END_NAMESPACE

#endif  /* IMP_GROUPNAME_FILTER_H */
