/**
 *  \file ListGroupnameContainer.cpp   \brief A list of Classnames.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/core/internal/CoreListGroupnameContainer.h"
#include "IMP/GroupnameModifier.h"
#include "IMP/GroupnameScore.h"
#include <IMP/core/internal/groupname_helpers.h>
#include <algorithm>


IMPCORE_BEGIN_INTERNAL_NAMESPACE

namespace {
  CoreListGroupnameContainer* get_list(GroupnameContainer *g) {
    return dynamic_cast<CoreListGroupnameContainer*>(g);
  }
}

IMP_ACTIVE_CONTAINER_DEF(CoreListGroupnameContainer);

CoreListGroupnameContainer
::CoreListGroupnameContainer(bool):
  internal::ListLikeGroupnameContainer(){}


CoreListGroupnameContainer
::CoreListGroupnameContainer(std::string name):
  internal::ListLikeGroupnameContainer(name){}


CoreListGroupnameContainer
::CoreListGroupnameContainer(const char *name):
  internal::ListLikeGroupnameContainer(name){}


void CoreListGroupnameContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out << get_number_of_classnames()
      << " classnames." << std::endl;
}



void CoreListGroupnameContainer::set_classnames(ClassnamesTemp sc) {
  if (!get_has_model() && !get_is_added_or_removed_container()
      && !sc.empty()) {
    set_model(IMP::internal::get_model(sc[0]));
  }
  update_list(sc);
}


void CoreListGroupnameContainer::clear_classnames() {
  ClassnamesTemp t;
  update_list(t);
}


void CoreListGroupnameContainer::add_classname(PassValue vt) {
  IMP_USAGE_CHECK(IMP::internal::is_valid(vt),
                  "Passed Classname cannot be NULL (or None)");

  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(vt));
  }
  add_to_list(vt);
  IMP_USAGE_CHECK(get_is_added_or_removed_container()
                  || !get_removed_groupnames_container()
                  ->get_contains(vt),
                  "You cannot remove and add the same item in one time step.");
}

void
CoreListGroupnameContainer::add_classnames(const ClassnamesTemp &c) {
  if (c.empty()) return;
  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(c[0]));
  }
  ClassnamesTemp cp= c;
  add_to_list(cp);
  IMP_IF_CHECK(USAGE) {
    for (unsigned int i=0; i< c.size(); ++i) {
      IMP_USAGE_CHECK(IMP::internal::is_valid(c[i]),
                    "Passed Classname cannot be NULL (or None)");
      IMP_USAGE_CHECK(get_is_added_or_removed_container()
                      || !get_removed_groupnames_container()
                      ->get_contains(c[i]),
            "You cannot remove and add the same item in one time step.");

    }
  }
}


ContainersTemp CoreListGroupnameContainer::get_input_containers() const {
  return ContainersTemp();
}


void CoreListGroupnameContainer::do_before_evaluate() {
  internal::ListLikeGroupnameContainer::do_before_evaluate();
}

void CoreListGroupnameContainer::do_after_evaluate() {
  internal::ListLikeGroupnameContainer::do_after_evaluate();
}

ParticlesTemp CoreListGroupnameContainer::get_state_input_particles() const {
  return ParticlesTemp();
}

ContainersTemp CoreListGroupnameContainer::get_state_input_containers() const {
  return ContainersTemp();
}

IMPCORE_END_INTERNAL_NAMESPACE
