/**
 *  \file ListTripletContainer.cpp   \brief A list of ParticleTriplets.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include <IMP/core/internal/triplet_helpers.h>
#include <IMP/TripletModifier.h>
#include <IMP/TripletScore.h>

IMPCORE_BEGIN_INTERNAL_NAMESPACE
void ListLikeTripletContainer::apply(const TripletModifier *sm) {
  IMP_CHECK_OBJECT(this);
  IMP_CHECK_OBJECT(sm);
  sm->apply(data_);
}
void ListLikeTripletContainer::apply(const TripletModifier *sm,
                                       DerivativeAccumulator &da) {
  IMP_CHECK_OBJECT(this);
  IMP_CHECK_OBJECT(sm);
  sm->apply(data_, da);
}
double ListLikeTripletContainer
::evaluate(const TripletScore *s,
           DerivativeAccumulator *da) const {
  IMP_CHECK_OBJECT(this);
  IMP_CHECK_OBJECT(s);
  return s->evaluate(data_, da);
}
double ListLikeTripletContainer
::evaluate_change(const TripletScore *s,
                  DerivativeAccumulator *da) const {
  IMP_CHECK_OBJECT(this);
  IMP_CHECK_OBJECT(s);
  return s->evaluate_change(data_, da);
}
double ListLikeTripletContainer
::evaluate_prechange(const TripletScore *s,
                     DerivativeAccumulator *da) const {
  IMP_CHECK_OBJECT(this);
  IMP_CHECK_OBJECT(s);
  return s->evaluate_prechange(data_, da);
}
unsigned int ListLikeTripletContainer
::get_number_of_particle_triplets() const {
  IMP_CHECK_OBJECT(this);
  return data_.size();
}
bool ListLikeTripletContainer
::get_contains_particle_triplet(const ParticleTriplet& vt) const {
  IMP_CHECK_OBJECT(this);
  return std::binary_search(data_.begin(), data_.end(), vt);
}

ParticleTriplet ListLikeTripletContainer
::get_particle_triplet(unsigned int i) const {
  IMP_CHECK_OBJECT(this);
  return data_[i];
}

void ListLikeTripletContainer
::do_show(std::ostream &out) const {
  out << "contains " << data_.size() << std::endl;
}


ParticlesTemp ListLikeTripletContainer
::get_contained_particles() const {
  return IMP::internal::flatten(data_);
}

bool ListLikeTripletContainer
::get_contained_particles_changed() const {
  return !get_added()->data_.empty() || !get_removed()->data_.empty();
}


IMPCORE_END_INTERNAL_NAMESPACE
