/**
 *  \file ListSingletonContainer.cpp   \brief A list of Particles.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/core/internal/CoreListSingletonContainer.h"
#include "IMP/SingletonModifier.h"
#include "IMP/SingletonScore.h"
#include <IMP/core/internal/singleton_helpers.h>
#include <algorithm>


IMPCORE_BEGIN_INTERNAL_NAMESPACE

namespace {
  CoreListSingletonContainer* get_list(SingletonContainer *g) {
    return dynamic_cast<CoreListSingletonContainer*>(g);
  }
}

IMP_ACTIVE_CONTAINER_DEF(CoreListSingletonContainer);

CoreListSingletonContainer
::CoreListSingletonContainer(bool):
  internal::ListLikeSingletonContainer(){}


CoreListSingletonContainer
::CoreListSingletonContainer(std::string name):
  internal::ListLikeSingletonContainer(name){}


CoreListSingletonContainer
::CoreListSingletonContainer(const char *name):
  internal::ListLikeSingletonContainer(name){}


void CoreListSingletonContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out << get_number_of_particles()
      << " particles." << std::endl;
}



void CoreListSingletonContainer::set_particles(ParticlesTemp sc) {
  if (!get_has_model() && !get_is_added_or_removed_container()
      && !sc.empty()) {
    set_model(IMP::internal::get_model(sc[0]));
  }
  update_list(sc);
}


void CoreListSingletonContainer::clear_particles() {
  ParticlesTemp t;
  update_list(t);
}


void CoreListSingletonContainer::add_particle(Particle* vt) {
  IMP_USAGE_CHECK(IMP::internal::is_valid(vt),
                  "Passed Particle cannot be NULL (or None)");

  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(vt));
  }
  add_to_list(vt);
  IMP_USAGE_CHECK(get_is_added_or_removed_container()
                  || !get_removed_singletons_container()
                  ->get_contains(vt),
                  "You cannot remove and add the same item in one time step.");
}

void
CoreListSingletonContainer::add_particles(const ParticlesTemp &c) {
  if (c.empty()) return;
  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(c[0]));
  }
  ParticlesTemp cp= c;
  add_to_list(cp);
  IMP_IF_CHECK(USAGE) {
    for (unsigned int i=0; i< c.size(); ++i) {
      IMP_USAGE_CHECK(IMP::internal::is_valid(c[i]),
                    "Passed Particle cannot be NULL (or None)");
      IMP_USAGE_CHECK(get_is_added_or_removed_container()
                      || !get_removed_singletons_container()
                      ->get_contains(c[i]),
            "You cannot remove and add the same item in one time step.");

    }
  }
}


ContainersTemp CoreListSingletonContainer::get_input_containers() const {
  return ContainersTemp();
}


void CoreListSingletonContainer::do_before_evaluate() {
  internal::ListLikeSingletonContainer::do_before_evaluate();
}

void CoreListSingletonContainer::do_after_evaluate() {
  internal::ListLikeSingletonContainer::do_after_evaluate();
}

ParticlesTemp CoreListSingletonContainer::get_state_input_particles() const {
  return ParticlesTemp();
}

ContainersTemp CoreListSingletonContainer::get_state_input_containers() const {
  return ContainersTemp();
}

IMPCORE_END_INTERNAL_NAMESPACE
