/**
 *  \file ListQuadContainer.cpp   \brief A list of ParticleQuads.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/core/internal/CoreListQuadContainer.h"
#include "IMP/QuadModifier.h"
#include "IMP/QuadScore.h"
#include <IMP/core/internal/quad_helpers.h>
#include <algorithm>


IMPCORE_BEGIN_INTERNAL_NAMESPACE

namespace {
  CoreListQuadContainer* get_list(QuadContainer *g) {
    return dynamic_cast<CoreListQuadContainer*>(g);
  }
}

IMP_ACTIVE_CONTAINER_DEF(CoreListQuadContainer);

CoreListQuadContainer
::CoreListQuadContainer(bool):
  internal::ListLikeQuadContainer(){}


CoreListQuadContainer
::CoreListQuadContainer(std::string name):
  internal::ListLikeQuadContainer(name){}


CoreListQuadContainer
::CoreListQuadContainer(const char *name):
  internal::ListLikeQuadContainer(name){}


void CoreListQuadContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out << get_number_of_particle_quads()
      << " particle_quads." << std::endl;
}



void CoreListQuadContainer::set_particle_quads(ParticleQuadsTemp sc) {
  if (!get_has_model() && !get_is_added_or_removed_container()
      && !sc.empty()) {
    set_model(IMP::internal::get_model(sc[0]));
  }
  update_list(sc);
}


void CoreListQuadContainer::clear_particle_quads() {
  ParticleQuadsTemp t;
  update_list(t);
}


void CoreListQuadContainer::add_particle_quad(const ParticleQuad& vt) {
  IMP_USAGE_CHECK(IMP::internal::is_valid(vt),
                  "Passed ParticleQuad cannot be NULL (or None)");

  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(vt));
  }
  add_to_list(vt);
  IMP_USAGE_CHECK(get_is_added_or_removed_container()
                  || !get_removed_quads_container()
                  ->get_contains(vt),
                  "You cannot remove and add the same item in one time step.");
}

void
CoreListQuadContainer::add_particle_quads(const ParticleQuadsTemp &c) {
  if (c.empty()) return;
  if (!get_has_model() && !get_is_added_or_removed_container()) {
    set_model(IMP::internal::get_model(c[0]));
  }
  ParticleQuadsTemp cp= c;
  add_to_list(cp);
  IMP_IF_CHECK(USAGE) {
    for (unsigned int i=0; i< c.size(); ++i) {
      IMP_USAGE_CHECK(IMP::internal::is_valid(c[i]),
                    "Passed ParticleQuad cannot be NULL (or None)");
      IMP_USAGE_CHECK(get_is_added_or_removed_container()
                      || !get_removed_quads_container()
                      ->get_contains(c[i]),
            "You cannot remove and add the same item in one time step.");

    }
  }
}


ContainersTemp CoreListQuadContainer::get_input_containers() const {
  return ContainersTemp();
}


void CoreListQuadContainer::do_before_evaluate() {
  internal::ListLikeQuadContainer::do_before_evaluate();
}

void CoreListQuadContainer::do_after_evaluate() {
  internal::ListLikeQuadContainer::do_after_evaluate();
}

ParticlesTemp CoreListQuadContainer::get_state_input_particles() const {
  return ParticlesTemp();
}

ContainersTemp CoreListQuadContainer::get_state_input_containers() const {
  return ContainersTemp();
}

IMPCORE_END_INTERNAL_NAMESPACE
