/**
 *  \file PairRestraint.cpp
 *  \brief Implementation
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/core/PairRestraint.h"
#include <IMP/internal/container_helpers.h>

#include <IMP/log.h>


IMPCORE_BEGIN_NAMESPACE

PairRestraint
::PairRestraint(PairScore *ss,
                     const ParticlePair& vt,
                     std::string name):
  Restraint(name),
  ss_(ss),
  v_(vt),
  score_(std::numeric_limits<double>::quiet_NaN())
{
}

double PairRestraint
::unprotected_evaluate(DerivativeAccumulator *accum) const
{
  IMP_OBJECT_LOG;
  IMP_CHECK_OBJECT(ss_);
  score_ = ss_->evaluate(v_, accum);

  return score_;
}

double PairRestraint
::unprotected_incremental_evaluate(DerivativeAccumulator *accum) const
{
  if (IMP::internal::is_dirty(v_)) {
    score_+=ss_->evaluate_change(v_, accum);
  }
  return score_;
}

ParticlesList PairRestraint::get_interacting_particles() const
{
  return ss_->get_interacting_particles(v_);
}

ParticlesTemp PairRestraint::get_input_particles() const
{
  return ss_->get_input_particles(v_);
}

ContainersTemp PairRestraint::get_input_containers() const
{
  return ss_->get_input_containers(v_);
}

void PairRestraint::do_show(std::ostream& out) const
{
  out << "score " << *ss_ << std::endl;
  out << "data " << IMP::internal::streamable(v_).get_name() << std::endl;
}

IMPCORE_END_NAMESPACE
