/**
 *  \file DifferenceSingletonContainer.h
 *  \brief Return all singletons from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_DIFFERENCE_SINGLETON_CONTAINER_H
#define IMPCORE_DIFFERENCE_SINGLETON_CONTAINER_H

#include "../core_config.h"

#include <IMP/SingletonContainer.h>

IMPCORE_BEGIN_INTERNAL_NAMESPACE

/** \brief Return all unordered singletons of particles taken from
    the SingletonContainer


    It does not do any change tracking. All particles in b must be in a.

    Returns the set b-a.
 */
class IMPCOREEXPORT DifferenceSingletonContainer : public SingletonContainer
{
  IMP::internal::OwnerPointer<SingletonContainer> a_, b_;
 public:
  DifferenceSingletonContainer(SingletonContainer *a, SingletonContainer *b);

  IMP_SINGLETON_CONTAINER(DifferenceSingletonContainer);
};


IMPCORE_END_INTERNAL_NAMESPACE

#endif  /* IMPCORE_DIFFERENCE_SINGLETON_CONTAINER_H */
