/**
 *  \file CoreTripletsRestraint.h
 *  \brief Apply a TripletScore to each ParticleTriplet in a list.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_INTERNAL_CORE_TRIPLETS_RESTRAINT_H
#define IMPCORE_INTERNAL_CORE_TRIPLETS_RESTRAINT_H

#include "../core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/TripletScore.h>
#include <IMP/TripletContainer.h>

#include <iostream>

IMPCORE_BEGIN_INTERNAL_NAMESPACE

//! Applies a TripletScore to each ParticleTriplet in a list.
/** This restraint stores the used particles in a ParticleTriplets.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used). By default
    a ListTripletContainer is used and the
    {add_, set_, clear_}particle_triplet{s} methods can be used.

    \see TripletRestraint
 */
class IMPCOREEXPORT CoreTripletsRestraint : public Restraint
{
  IMP::internal::OwnerPointer<TripletScore> ss_;
  IMP::internal::OwnerPointer<TripletContainer> pc_;
  mutable double score_;
public:

 //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  CoreTripletsRestraint(TripletScore *ss,
                      TripletContainer *pc,
                      std::string name="TripletsRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(CoreTripletsRestraint);

  //! Get the container used to store Particles
  TripletContainer* get_triplet_container() {
    return pc_;
  }

  TripletScore* get_triplet_score() const {
    return ss_;
  }
};

IMPCORE_END_INTERNAL_NAMESPACE

#endif  /* IMPCORE_INTERNAL_CORE_TRIPLETS_RESTRAINT_H */
