/**
 *  \file CorePairsRestraint.h
 *  \brief Apply a PairScore to each ParticlePair in a list.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_INTERNAL_CORE_PAIRS_RESTRAINT_H
#define IMPCORE_INTERNAL_CORE_PAIRS_RESTRAINT_H

#include "../core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/PairScore.h>
#include <IMP/PairContainer.h>

#include <iostream>

IMPCORE_BEGIN_INTERNAL_NAMESPACE

//! Applies a PairScore to each ParticlePair in a list.
/** This restraint stores the used particles in a ParticlePairs.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used). By default
    a ListPairContainer is used and the
    {add_, set_, clear_}particle_pair{s} methods can be used.

    \see PairRestraint
 */
class IMPCOREEXPORT CorePairsRestraint : public Restraint
{
  IMP::internal::OwnerPointer<PairScore> ss_;
  IMP::internal::OwnerPointer<PairContainer> pc_;
  mutable double score_;
public:

 //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  CorePairsRestraint(PairScore *ss,
                      PairContainer *pc,
                      std::string name="PairsRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(CorePairsRestraint);

  //! Get the container used to store Particles
  PairContainer* get_pair_container() {
    return pc_;
  }

  PairScore* get_pair_score() const {
    return ss_;
  }
};

IMPCORE_END_INTERNAL_NAMESPACE

#endif  /* IMPCORE_INTERNAL_CORE_PAIRS_RESTRAINT_H */
