/**
 *  \file core/internal/CoreClosePairContainer.h
 *  \brief Return all pairs from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. Close rights reserved.
 */

#ifndef IMPCORE_INTERNAL_CORE_CLOSE_PAIR_CONTAINER_H
#define IMPCORE_INTERNAL_CORE_CLOSE_PAIR_CONTAINER_H

#include "../core_config.h"
#include "../ClosePairsFinder.h"
#include "MovedSingletonContainer.h"
#include <IMP/PairContainer.h>
#include <IMP/PairFilter.h>
#include <IMP/SingletonContainer.h>
#include "pair_helpers.h"

IMPCORE_BEGIN_INTERNAL_NAMESPACE


class IMPCOREEXPORT CoreClosePairContainer :
public internal::ListLikePairContainer
{
  IMP::internal::OwnerPointer<SingletonContainer> c_;
  IMP::internal::OwnerPointer<ClosePairsFinder> cpf_;
  IMP::internal::OwnerPointer<internal::MovedSingletonContainer> moved_;
  bool first_call_;
  double distance_, slack_;
  ParticlePairsTemp data_;
  IMP_ACTIVE_CONTAINER_DECL(CoreClosePairContainer);
  void initialize(SingletonContainer *c, double distance,
                  double slack, Model *m, ClosePairsFinder *cpf);
public:
  CoreClosePairContainer(SingletonContainer *c, Model *m, double distance,
                         ClosePairsFinder *cpf,
                         double slack=1);

  IMP_LIST(public, PairFilter, pair_filter,
           PairFilter*, PairFilters);

  IMP_LISTLIKE_PAIR_CONTAINER(CoreClosePairContainer);
};


IMPCORE_END_INTERNAL_NAMESPACE

#endif  /* IMPCORE_INTERNAL_CORE_CLOSE_PAIR_CONTAINER_H */
