/**
 *  \file TripletRestraint.h
 *  \brief Apply a TripletScore to a ParticleTriplet.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_TRIPLET_RESTRAINT_H
#define IMPCORE_TRIPLET_RESTRAINT_H

#include "core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/TripletScore.h>

#include <iostream>

IMPCORE_BEGIN_NAMESPACE

//! Applies a TripletScore to a ParticleTriplet.
/** This restraint stores a ParticleTriplet.
    \see TripletRestraint
 */
class IMPCOREEXPORT TripletRestraint : public Restraint
{
  IMP::internal::OwnerPointer<TripletScore> ss_;
  ParticleTriplet v_;
  mutable double score_;
public:
  //! Create the restraint.
  /** This function takes the function to apply to the
      stored Triplet and the Triplet.
   */
  TripletRestraint(TripletScore *ss,
                     const ParticleTriplet& vt,
                     std::string name="TripletRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(TripletRestraint);
};

IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_TRIPLET_RESTRAINT_H */
