/**
 *  \file SingletonRestraint.h
 *  \brief Apply a SingletonScore to a Particle.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_SINGLETON_RESTRAINT_H
#define IMPCORE_SINGLETON_RESTRAINT_H

#include "core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/SingletonScore.h>

#include <iostream>

IMPCORE_BEGIN_NAMESPACE

//! Applies a SingletonScore to a Particle.
/** This restraint stores a Particle.
    \see SingletonRestraint
 */
class IMPCOREEXPORT SingletonRestraint : public Restraint
{
  IMP::internal::OwnerPointer<SingletonScore> ss_;
  Pointer<Particle> v_;
  mutable double score_;
public:
  //! Create the restraint.
  /** This function takes the function to apply to the
      stored Singleton and the Singleton.
   */
  SingletonRestraint(SingletonScore *ss,
                     Particle* vt,
                     std::string name="SingletonRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(SingletonRestraint);
};

IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_SINGLETON_RESTRAINT_H */
