/**
 *  \file QuadRestraint.h
 *  \brief Apply a QuadScore to a ParticleQuad.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCORE_QUAD_RESTRAINT_H
#define IMPCORE_QUAD_RESTRAINT_H

#include "core_config.h"

#include <IMP/Restraint.h>
#include <IMP/Pointer.h>
#include <IMP/QuadScore.h>

#include <iostream>

IMPCORE_BEGIN_NAMESPACE

//! Applies a QuadScore to a ParticleQuad.
/** This restraint stores a ParticleQuad.
    \see QuadRestraint
 */
class IMPCOREEXPORT QuadRestraint : public Restraint
{
  IMP::internal::OwnerPointer<QuadScore> ss_;
  ParticleQuad v_;
  mutable double score_;
public:
  //! Create the restraint.
  /** This function takes the function to apply to the
      stored Quad and the Quad.
   */
  QuadRestraint(QuadScore *ss,
                     const ParticleQuad& vt,
                     std::string name="QuadRestraint %1%");

  IMP_INCREMENTAL_RESTRAINT(QuadRestraint);
};

IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_QUAD_RESTRAINT_H */
