/**
 *  \file QuadConstraint.h
 *  \brief Use a QuadModifier applied to a ParticleQuads to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_QUAD_CONSTRAINT_H
#define IMPCORE_QUAD_CONSTRAINT_H

#include "core_config.h"
#include <IMP/QuadModifier.h>
#include <IMP/Constraint.h>
#include <IMP/Particle.h>

IMP_BEGIN_NAMESPACE
// for swig
class QuadModifier;
IMP_END_NAMESPACE

IMPCORE_BEGIN_NAMESPACE
//! Apply a QuadFunction to a Quad
/** The score state is passed up to two QuadModifiers, one to
    apply before evaluation and the other after. The one after
    should take a DerivativeAccumulator as its last argument for
    QuadModifier::apply() and will only be called if
    the score was computed with derivatives.

    \see QuadsConstraint
 */
class IMPCOREEXPORT QuadConstraint : public Constraint
{
  IMP::internal::OwnerPointer<QuadModifier> f_;
  IMP::internal::OwnerPointer<QuadModifier> af_;
  ParticleQuad v_;
public:
  /** before and after are the modifiers to apply before and after
      evaluate.
   */
  QuadConstraint(QuadModifier *before,
                      QuadModifier *after, const ParticleQuad& vt,
                      std::string name="QuadConstraint %1%");

  //! Apply this modifier to all the elements after an evaluate
  void set_after_evaluate_modifier(QuadModifier* f) {
    af_=f;
  }

  //! Apply this modifier to all the elements before an evaluate
  void set_before_evaluate_modifier(QuadModifier* f) {
    f_=f;
  }

  IMP_CONSTRAINT(QuadConstraint);
};


IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_QUAD_CONSTRAINT_H */
