/**
 *  \file PairConstraint.h
 *  \brief Use a PairModifier applied to a ParticlePairs to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_PAIR_CONSTRAINT_H
#define IMPCORE_PAIR_CONSTRAINT_H

#include "core_config.h"
#include <IMP/PairModifier.h>
#include <IMP/Constraint.h>
#include <IMP/Particle.h>

IMP_BEGIN_NAMESPACE
// for swig
class PairModifier;
IMP_END_NAMESPACE

IMPCORE_BEGIN_NAMESPACE
//! Apply a PairFunction to a Pair
/** The score state is passed up to two PairModifiers, one to
    apply before evaluation and the other after. The one after
    should take a DerivativeAccumulator as its last argument for
    PairModifier::apply() and will only be called if
    the score was computed with derivatives.

    \see PairsConstraint
 */
class IMPCOREEXPORT PairConstraint : public Constraint
{
  IMP::internal::OwnerPointer<PairModifier> f_;
  IMP::internal::OwnerPointer<PairModifier> af_;
  ParticlePair v_;
public:
  /** before and after are the modifiers to apply before and after
      evaluate.
   */
  PairConstraint(PairModifier *before,
                      PairModifier *after, const ParticlePair& vt,
                      std::string name="PairConstraint %1%");

  //! Apply this modifier to all the elements after an evaluate
  void set_after_evaluate_modifier(PairModifier* f) {
    af_=f;
  }

  //! Apply this modifier to all the elements before an evaluate
  void set_before_evaluate_modifier(PairModifier* f) {
    f_=f;
  }

  IMP_CONSTRAINT(PairConstraint);
};


IMPCORE_END_NAMESPACE

#endif  /* IMPCORE_PAIR_CONSTRAINT_H */
