/**
 *  \file PairContainerSet.cpp
 *  \brief A set of PairContainers.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/PairContainerSet.h"
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

namespace {
  PairContainerSet* get_set(PairContainer* c) {
    return dynamic_cast<PairContainerSet*>(c);
  }
}

PairContainerSet
::PairContainerSet(bool): PairContainer("added or removed for set") {
}

PairContainerSet
::PairContainerSet(std::string name):
  PairContainer(name) {
  set_added_and_removed_containers( create_untracked_container(),
                                    create_untracked_container());
}

PairContainerSet
::PairContainerSet(const PairContainers& in,
                        std::string name):
  PairContainer(name) {
  set_pair_containers(in);
  set_added_and_removed_containers( create_untracked_container(),
                                    create_untracked_container());
}


bool
PairContainerSet
::get_contains_particle_pair(const ParticlePair& vt) const {
  for (PairContainerConstIterator it= pair_containers_begin();
       it != pair_containers_end(); ++it) {
    if ((*it)->get_contains_particle_pair(vt)) return true;
  }
  return false;
}

void PairContainerSet::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out << get_number_of_particle_pairs()
      << " containers" << std::endl;
}

unsigned int
PairContainerSet::get_number_of_particle_pairs() const {
  unsigned int sum=0;
  for (PairContainerConstIterator it= pair_containers_begin();
       it != pair_containers_end(); ++it) {
    sum+= (*it)->get_number_of_particle_pairs();
  }
  return sum;
}

ParticlePair
PairContainerSet::get_particle_pair(unsigned int i) const {
  for (PairContainerConstIterator it= pair_containers_begin();
       it != pair_containers_end(); ++it) {
    if ( i >= (*it)->get_number_of_particle_pairs()) {
      i-= (*it)->get_number_of_particle_pairs();
    } else {
      return (*it)->get_particle_pair(i);
    }
  }
  throw IndexException("out of range");
}



IMP_LIST_IMPL(PairContainerSet,
              PairContainer,
              pair_container,
              PairContainer*,
              PairContainers,
              {
                if (!get_is_added_or_removed_container()) {
                  get_set(get_added_pairs_container())
                    ->add_pair_container(obj
                           ->get_added_pairs_container());
                }
                obj->set_was_used(true);
              },,
              if (!get_is_added_or_removed_container()) {
                get_set(get_removed_pairs_container())
                  ->add_pair_container(obj
                       ->get_removed_pairs_container());
              })


void PairContainerSet::apply(const PairModifier *sm) {
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    get_pair_container(i)->apply(sm);
  }
}

void PairContainerSet::apply(const PairModifier *sm,
                               DerivativeAccumulator &da) {
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    get_pair_container(i)->apply(sm, da);
  }
}

double PairContainerSet::evaluate(const PairScore *s,
                                       DerivativeAccumulator *da) const {
  double score=0;
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    score+=get_pair_container(i)->evaluate(s, da);
  }
  return score;
}


double PairContainerSet::evaluate_change(const PairScore *s,
                                              DerivativeAccumulator *da) const {
  double score=0;
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    score+=get_pair_container(i)->evaluate_change(s, da);
  }
  return score;
}

double PairContainerSet::evaluate_prechange(const PairScore *s,
                                             DerivativeAccumulator *da) const {
  double score=0;
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    score+=get_pair_container(i)->evaluate_prechange(s, da);
  }
  return score;
}


ContainersTemp PairContainerSet::get_input_containers() const {
  return ContainersTemp(pair_containers_begin(),
                        pair_containers_end());
}

ParticlesTemp PairContainerSet::get_contained_particles() const {
  ParticlesTemp ret;
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    ParticlesTemp cur= get_pair_container(i)->get_contained_particles();
    ret.insert(ret.end(), cur.begin(), cur.end());
  }
  return ret;
}

bool PairContainerSet::get_contained_particles_changed() const {
  for (unsigned int i=0; i< get_number_of_pair_containers(); ++i) {
    if (get_pair_container(i)->get_contained_particles_changed()) {
      return true;
    }
  }
  return false;
}


IMPCONTAINER_END_NAMESPACE
