/**
 *  \file ListTripletContainer.cpp   \brief A list of ParticleTriplets.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/ListTripletContainer.h"
#include "IMP/TripletModifier.h"
#include "IMP/TripletScore.h"
#include <IMP/core/internal/triplet_helpers.h>
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

ListTripletContainer
::ListTripletContainer(bool):
  P(true){}

ListTripletContainer
::ListTripletContainer(const ParticleTriplets &ps,
                         std::string name):
  P(name)
{
  if (ps.empty()) return;
  for (unsigned int i=0; i< ps.size(); ++i) {
    IMP_USAGE_CHECK(IMP::internal::is_valid(ps[i]),
                    "Passed ParticleTriplet cannot be NULL (or None)");
    IMP_USAGE_CHECK(IMP::internal::get_model(ps[i])
                    == IMP::internal::get_model(ps[0]),
                    "All particles in container must have the same model. "
                    << "Particle " << IMP::internal::get_name(ps[i])
                    << " does not.");
  }
  set_particle_triplets(ps);
}

ListTripletContainer
::ListTripletContainer(std::string name):
  P(name){
}

ListTripletContainer
::ListTripletContainer(const char *name):
  P(name){
}

void ListTripletContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out <<  get_number_of_particle_triplets()
      << " particle_triplets" << std::endl;
}

IMPCONTAINER_END_NAMESPACE
