/**
 *  \file ListQuadContainer.cpp   \brief A list of ParticleQuads.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/ListQuadContainer.h"
#include "IMP/QuadModifier.h"
#include "IMP/QuadScore.h"
#include <IMP/core/internal/quad_helpers.h>
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

ListQuadContainer
::ListQuadContainer(bool):
  P(true){}

ListQuadContainer
::ListQuadContainer(const ParticleQuads &ps,
                         std::string name):
  P(name)
{
  if (ps.empty()) return;
  for (unsigned int i=0; i< ps.size(); ++i) {
    IMP_USAGE_CHECK(IMP::internal::is_valid(ps[i]),
                    "Passed ParticleQuad cannot be NULL (or None)");
    IMP_USAGE_CHECK(IMP::internal::get_model(ps[i])
                    == IMP::internal::get_model(ps[0]),
                    "All particles in container must have the same model. "
                    << "Particle " << IMP::internal::get_name(ps[i])
                    << " does not.");
  }
  set_particle_quads(ps);
}

ListQuadContainer
::ListQuadContainer(std::string name):
  P(name){
}

ListQuadContainer
::ListQuadContainer(const char *name):
  P(name){
}

void ListQuadContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out <<  get_number_of_particle_quads()
      << " particle_quads" << std::endl;
}

IMPCONTAINER_END_NAMESPACE
