/**
 *  \file ListPairContainer.cpp   \brief A list of ParticlePairs.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#include "IMP/container/ListPairContainer.h"
#include "IMP/PairModifier.h"
#include "IMP/PairScore.h"
#include <IMP/core/internal/pair_helpers.h>
#include <algorithm>


IMPCONTAINER_BEGIN_NAMESPACE

ListPairContainer
::ListPairContainer(bool):
  P(true){}

ListPairContainer
::ListPairContainer(const ParticlePairs &ps,
                         std::string name):
  P(name)
{
  if (ps.empty()) return;
  for (unsigned int i=0; i< ps.size(); ++i) {
    IMP_USAGE_CHECK(IMP::internal::is_valid(ps[i]),
                    "Passed ParticlePair cannot be NULL (or None)");
    IMP_USAGE_CHECK(IMP::internal::get_model(ps[i])
                    == IMP::internal::get_model(ps[0]),
                    "All particles in container must have the same model. "
                    << "Particle " << IMP::internal::get_name(ps[i])
                    << " does not.");
  }
  set_particle_pairs(ps);
}

ListPairContainer
::ListPairContainer(std::string name):
  P(name){
}

ListPairContainer
::ListPairContainer(const char *name):
  P(name){
}

void ListPairContainer::do_show(std::ostream &out) const {
  IMP_CHECK_OBJECT(this);
  out <<  get_number_of_particle_pairs()
      << " particle_pairs" << std::endl;
}

IMPCONTAINER_END_NAMESPACE
