/**
 *  \file TripletsRestraint.h
 *  \brief Apply a TripletScore to each ParticleTriplet in a list.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_TRIPLETS_RESTRAINT_H
#define IMPCONTAINER_TRIPLETS_RESTRAINT_H

#include "container_config.h"

#include <IMP/core/internal/CoreTripletsRestraint.h>

#include <iostream>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a TripletScore to each ParticleTriplet in a list.
/** This restraint stores the used particles in a ParticleTriplets.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used). By default
    a ListTripletContainer is used and the
    {add_, set_, clear_}particle_triplet{s} methodas can be used.

    Examples using various multiplicity containers:
    \htmlinclude restrain_in_sphere.py.html
    \htmlinclude nonbonded_interactions.py.html

    \see TripletRestraint
 */
class IMPCONTAINEREXPORT TripletsRestraint :
#if defined(SWIG) || defined(IMP_DOXYGEN)
public Restraint
#else
public core::internal::CoreTripletsRestraint
#endif
{
  typedef core::internal::CoreTripletsRestraint P;
  IMP::internal::OwnerPointer<TripletScore> ss_;
  IMP::internal::OwnerPointer<TripletContainer> pc_;
  mutable double score_;
public:

 //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  TripletsRestraint(TripletScore *ss,
                      TripletContainer *pc,
                      std::string name="TripletsRestraint %1%");

#if defined(IMP_DOXYGEN) || defined(SWIG)
  IMP_INCREMENTAL_RESTRAINT(TripletsRestraint);

  //! Get the container used to store Particles
  TripletContainer* get_triplet_container() {
    return pc_;
  }

  TripletScore* get_triplet_score() const {
    return ss_;
  }
#else
  IMP_OBJECT(TripletsRestraint);
#endif
};

IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_TRIPLETS_RESTRAINT_H */
