/**
 *  \file TripletContainerSet.h
 *  \brief Store a set of TripletContainers
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_TRIPLET_CONTAINER_SET_H
#define IMPCONTAINER_TRIPLET_CONTAINER_SET_H

#include "container_config.h"
#include <IMP/TripletContainer.h>
#include <IMP/container_macros.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Stores a set of TripletContainers
/** The input sets must be disjoint. This can change if there is
    demand for it.

    \usesconstraint
 */
class IMPCONTAINEREXPORT TripletContainerSet
  : public TripletContainer
{
 // to not have added and removed
 TripletContainerSet(bool);
public:
  //! Construct and empty set
  TripletContainerSet(std::string name="TripletContainerSet %1%");

  TripletContainerSet(const TripletContainers &in,
                        std::string name="TripletContainerSet %1%");

  IMP_TRIPLET_CONTAINER(TripletContainerSet);
 /** @name Methods to control the nested container

     This container merges a set of nested containers. To add
     or remove nested containers, use the methods below.
  */
  /**@{*/
  IMP_LIST(public, TripletContainer, triplet_container,
           TripletContainer*, TripletContainers);
  /**@}*/

  static TripletContainerSet *create_untracked_container() {
    TripletContainerSet *lsc = new TripletContainerSet(false);
    return lsc;
  }
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_TRIPLET_CONTAINER_SET_H */
