/**
 *  \file SingletonsOptimizerState.h
 *  \brief Use a SingletonModifier applied to a Particles to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_SINGLETONS_OPTIMIZER_STATE_H
#define IMPCONTAINER_SINGLETONS_OPTIMIZER_STATE_H

#include "container_config.h"
#include <IMP/SingletonContainer.h>
#include <IMP/SingletonModifier.h>
#include <IMP/OptimizerState.h>

IMP_BEGIN_NAMESPACE
// for swig
class SingletonContainer;
class SingletonModifier;
IMP_END_NAMESPACE

IMPCONTAINER_BEGIN_NAMESPACE
//! Apply a SingletonFunction to a SingletonContainer to maintain an invariant
/** \ingroup restraint
    \see SingletonOptimizerState
 */
class IMPCONTAINEREXPORT SingletonsOptimizerState : public OptimizerState
{
  IMP::internal::OwnerPointer<SingletonModifier> f_;
  IMP::internal::OwnerPointer<SingletonContainer> c_;
public:
  /** \param[in] c The Container to hold the elements to process
      \param[in] gf The SingletonModifier to apply to all elements.
      \param[in] name The name to use for this Object
   */
  SingletonsOptimizerState(SingletonContainer *c, SingletonModifier *gf,
                           std::string name="SingletonsOptimizerState %1%");

  IMP_OPTIMIZER_STATE(SingletonsOptimizerState);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_SINGLETONS_OPTIMIZER_STATE_H */
