/**
 *  \file PairsOptimizerState.h
 *  \brief Use a PairModifier applied to a ParticlePairs to
 *  maintain an invariant
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_PAIRS_OPTIMIZER_STATE_H
#define IMPCONTAINER_PAIRS_OPTIMIZER_STATE_H

#include "container_config.h"
#include <IMP/PairContainer.h>
#include <IMP/PairModifier.h>
#include <IMP/OptimizerState.h>

IMP_BEGIN_NAMESPACE
// for swig
class PairContainer;
class PairModifier;
IMP_END_NAMESPACE

IMPCONTAINER_BEGIN_NAMESPACE
//! Apply a PairFunction to a PairContainer to maintain an invariant
/** \ingroup restraint
    \see PairOptimizerState
 */
class IMPCONTAINEREXPORT PairsOptimizerState : public OptimizerState
{
  IMP::internal::OwnerPointer<PairModifier> f_;
  IMP::internal::OwnerPointer<PairContainer> c_;
public:
  /** \param[in] c The Container to hold the elements to process
      \param[in] gf The PairModifier to apply to all elements.
      \param[in] name The name to use for this Object
   */
  PairsOptimizerState(PairContainer *c, PairModifier *gf,
                           std::string name="PairsOptimizerState %1%");

  IMP_OPTIMIZER_STATE(PairsOptimizerState);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_PAIRS_OPTIMIZER_STATE_H */
