/**
 *  \file MinimumQuadRestraint.h
 *  \brief Score based on the minimum score over a set of Quads
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_MINIMUM_QUAD_RESTRAINT_H
#define IMPCONTAINER_MINIMUM_QUAD_RESTRAINT_H

#include "container_config.h"
#include <IMP/Restraint.h>
#include <IMP/QuadScore.h>
#include <IMP/QuadContainer.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Score based on the minimum quad over a set of Quads
/** The score is evaluated for each of the Quads in the container
    and the value of the minimum n scores is used. That is,
    if n is 1, the value of the restraint is the value of the minimum
    score over the container.
 */
class IMPCONTAINEREXPORT MinimumQuadRestraint
: public Restraint
{
  IMP::internal::OwnerPointer<QuadScore> f_;
  IMP::internal::OwnerPointer<QuadContainer> c_;
  unsigned int n_;
public:
  /** n is the number of minimum scores to use.
   */
  MinimumQuadRestraint(QuadScore *f,
                                 QuadContainer *c,
                                 unsigned int n=1,
                                 std::string name
                                 ="MinimumQuadRestraint %1%");

  IMP_RESTRAINT(MinimumQuadRestraint);

  //! Set the number of lowest scores to use.
  void set_n(unsigned int n) { n_=n;}
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_MINIMUM_QUAD_RESTRAINT_H */
