/**
 *  \file MinimumPairRestraint.h
 *  \brief Score based on the minimum score over a set of Pairs
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_MAXIMUM_PAIR_RESTRAINT_H
#define IMPCONTAINER_MAXIMUM_PAIR_RESTRAINT_H

#include "container_config.h"
#include <IMP/Restraint.h>
#include <IMP/PairScore.h>
#include <IMP/PairContainer.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Score based on the maximum pair over a set of Pairs
/** The score is evaluated for each of the Pairs in the container
    and the value of the maximum n scores is used. That is,
    if n is 1, the value of the restraint is the value of the maximum
    score over the container.
 */
class IMPCONTAINEREXPORT MaximumPairRestraint
: public Restraint
{
  IMP::internal::OwnerPointer<PairScore> f_;
  IMP::internal::OwnerPointer<PairContainer> c_;
  unsigned int n_;
public:
  /** n is the number of maximum scores to use.
   */
  MaximumPairRestraint(PairScore *f,
                                 PairContainer *c,
                                 unsigned int n=1,
                                 std::string name
                                 ="MaximumPairRestraint %1%");

  IMP_RESTRAINT(MaximumPairRestraint);

  //! Set the number of lowest scores to use.
  void set_n(unsigned int n) { n_=n;}
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_MAXIMUM_PAIR_RESTRAINT_H */
