/**
 *  \file CloseBipartitePairContainer.h
 *  \brief Return all pairs from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. Close rights reserved.
 */

#ifndef IMPCONTAINER_CLOSE_BIPARTITE_PAIR_CONTAINER_H
#define IMPCONTAINER_CLOSE_BIPARTITE_PAIR_CONTAINER_H

#include "container_config.h"
#include <IMP/core/ClosePairsFinder.h>
#include <IMP/core/internal/MovedSingletonContainer.h>
#include <IMP/PairContainer.h>
#include <IMP/PairFilter.h>
#include <IMP/SingletonContainer.h>
#include <IMP/container/ListPairContainer.h>
#include <IMP/container/PairContainerSet.h>
#include <IMP/core/internal/pair_helpers.h>

IMPCONTAINER_BEGIN_NAMESPACE

/** \brief Return all close unordered pairs of particles taken from
    the SingletonContainer

    See ClosePairContainer for a more detailed description. This
    container lists all close pairs of particles where one particle is
    taken from each of the input sets.

    \usesconstraint
 */
class IMPCONTAINEREXPORT CloseBipartitePairContainer:
#if defined(IMP_DOXYGEN) || defined(SWIG)
public PairContainer
#else
public IMP::core::internal::ListLikePairContainer
#endif
{
  typedef IMP::core::internal::ListLikePairContainer P;
  IMP::internal::OwnerPointer<SingletonContainer> a_, b_;
  IMP::internal::OwnerPointer<core::ClosePairsFinder> cpf_;
  IMP::internal::OwnerPointer<core::internal::MovedSingletonContainer>
    moveda_, movedb_;
  bool first_call_;
  double distance_, slack_;
  IMP_ACTIVE_CONTAINER_DECL(CloseBipartitePairContainer);
  void initialize(SingletonContainer *a,
                  SingletonContainer *b, double distance,
                  double slack, Model *m, core::ClosePairsFinder *cpf);
public:
  //! Get the individual particles from the passed SingletonContainer
  CloseBipartitePairContainer(SingletonContainer *a,
                              SingletonContainer *b,
                              double distance,
                              double slack=1);
  //! If the container is empty, you can pass the model explicitly
  CloseBipartitePairContainer(SingletonContainer *a,
                              SingletonContainer *b,
                              Model *m, double distance,
                              double slack=1);

  //! Get the individual particles from the passed SingletonContainer
  CloseBipartitePairContainer(SingletonContainer *a,
                              SingletonContainer *b,
                              double distance,
                              core::ClosePairsFinder *cpf,
                              double slack=1);
  //! If the container is empty, you can pass the model explicitly
  CloseBipartitePairContainer(SingletonContainer *a,
                              SingletonContainer *b,
                              Model *m, double distance,
                              core::ClosePairsFinder *cpf,
                              double slack=1);

  /** @name Methods to control the set of filters

     PairContainer objects can be used as filters to prevent
     the addition of pairs to the containeroutput list. Pairs
     which are contained in any container added to this list
     will be excluded from the close pairs list.
  */
  /**@{*/
  IMP_LIST(public, PairFilter, pair_filter,
           PairFilter*, PairFilters);
   /**@}*/

#if defined(IMP_DOXYGEN) || defined(SWIG)
  IMP_PAIR_CONTAINER(CloseBipartitePairContainer);
#else
  IMP_LISTLIKE_PAIR_CONTAINER(CloseBipartitePairContainer);
#endif
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_CLOSE_BIPARTITE_PAIR_CONTAINER_H */
