/**
 *  \file AllPairContainer.h
 *  \brief Return all pairs from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_ALL_PAIR_CONTAINER_H
#define IMPCONTAINER_ALL_PAIR_CONTAINER_H

#include "container_config.h"

#include <IMP/PairContainer.h>
#include <IMP/SingletonContainer.h>
#include <IMP/container/ListPairContainer.h>
#include <IMP/container/PairContainerSet.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Return all unordered pairs of particles taken from the SingletonContainer
/** Here is an example using this container to restrain all particles in a set
    to be within a a certain distance of one another.
    \verbinclude restrain_diameter.py

    \note Sequential access is much more efficient than random access which is
    suicidally slow for now. Complain if you want fast(er) random access.
    We might listen.

    \usesconstraint
 */
class IMPCONTAINEREXPORT AllPairContainer : public PairContainer
{
  IMP::internal::OwnerPointer<SingletonContainer> c_;
  mutable int a_, b_, i_;
  friend class AllBipartitePairContainer;
  AllPairContainer(SingletonContainer *c, bool);
public:
  //! Get the individual particles from the passed SingletonContainer
  AllPairContainer(SingletonContainer *c);

  static AllPairContainer *create_untracked_container(SingletonContainer *c) {
    AllPairContainer *lsc = new AllPairContainer(c, false);
    return lsc;
  }

  IMP_PAIR_CONTAINER(AllPairContainer);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_ALL_PAIR_CONTAINER_H */
