/**
 *  \file AllBipartitePairContainer.h
 *  \brief Return all pairs from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_ALL_BIPARTITE_PAIR_CONTAINER_H
#define IMPCONTAINER_ALL_BIPARTITE_PAIR_CONTAINER_H

#include "container_config.h"

#include <IMP/PairContainer.h>
#include <IMP/SingletonContainer.h>
#include <IMP/container/ListPairContainer.h>
#include <IMP/container/PairContainerSet.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Return all bipartite pairs between two containers
/** \see AllPairContainer

    \usesconstraint
 */
class IMPCONTAINEREXPORT AllBipartitePairContainer : public PairContainer
{
  IMP::internal::OwnerPointer<SingletonContainer> a_, b_;
  friend class AllPairContainer;
  AllBipartitePairContainer(SingletonContainer *a,
                                 SingletonContainer *b, bool);
public:
  AllBipartitePairContainer(SingletonContainer *a,
                                 SingletonContainer *b);

  static AllBipartitePairContainer *
    create_untracked_container(SingletonContainer *a,
                               SingletonContainer *b) {
    AllBipartitePairContainer *lsc
      = new AllBipartitePairContainer(a,b, false);
    return lsc;
  }

  IMP_PAIR_CONTAINER(AllBipartitePairContainer);
};


IMPCONTAINER_END_NAMESPACE

#endif  /* IMPCONTAINER_ALL_BIPARTITE_PAIR_CONTAINER_H */
